/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStack;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerItemStackClient
implements IIngredientComponentTerminalStorageHandlerClient<ItemStack, Integer> {
    private final IngredientComponentTerminalStorageHandlerItemStack handler;

    public IngredientComponentTerminalStorageHandlerItemStackClient(IngredientComponentTerminalStorageHandlerItemStack handler) {
        this.handler = handler;
    }

    @Override
    public void drawInstance(GuiGraphics guiGraphics, ItemStack instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        ItemStack instanceCopy = instance.copy();
        GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            guiGraphics.renderItem(instanceCopy, x, y);
            renderItem.renderItemDecorations(Minecraft.getInstance().font, instanceCopy, x, y, label);
        } else {
            IModHelpers.get().getGuiHelpers().renderTooltip(gui, guiGraphics, x, y, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), mouseX, mouseY, () -> {
                List lines = instanceCopy.getTooltipLines(Item.TooltipContext.of((HolderLookup.Provider)Minecraft.getInstance().player.registryAccess()), (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                if (additionalTooltipLines != null) {
                    lines.addAll(additionalTooltipLines);
                }
                this.handler.addQuantityTooltip(lines, instanceCopy);
                return lines;
            });
        }
    }

    @Override
    public Predicate<ItemStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return switch (searchMode) {
            default -> throw new MatchException(null, null);
            case SearchMode.MOD -> i -> Optional.ofNullable(i.getItem().getCreatorModId((HolderLookup.Provider)Minecraft.getInstance().getConnection().registryAccess(), i)).orElse("minecraft").toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            case SearchMode.TOOLTIP -> i -> i.getTooltipLines(Item.TooltipContext.of((HolderLookup.Provider)Minecraft.getInstance().player.registryAccess()), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().anyMatch(s -> s.getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*"));
            case SearchMode.TAG -> i -> i.getItem().builtInRegistryHolder().tags().filter(tag -> tag.location().toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).anyMatch(tag -> BuiltInRegistries.ITEM.get(tag).isPresent());
            case SearchMode.DEFAULT -> i -> i.getHoverName().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
        };
    }
}

