/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.proxy.ClientProxy;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageSlot;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridBalance;

public class ContainerScreenTerminalStorage<L, C extends ContainerTerminalStorageBase<L>>
extends ContainerScreenExtended<C>
implements ContainerTerminalStorageBase.ISelectedClientTabProvider {
    private static int TAB_OFFSET_X = 24;
    private static int TAB_WIDTH = 24;
    private static int TAB_UNSELECTED_HEIGHT = 21;
    private static int TAB_SELECTED_HEIGHT = 24;
    private static int TAB_ICON_OFFSET = 4;
    private static int TAB_UNSELECTED_TEXTURE_X = 118;
    private static int TAB_SELECTED_TEXTURE_X = 142;
    private static int TAB_UNSELECTED_TEXTURE_Y = 0;
    private static int TAB_SELECTED_TEXTURE_Y = 0;
    private static int SCROLL_Y = 40;
    private static int SEARCH_X = 103;
    private static int SEARCH_Y = 27;
    private static int SEARCH_HEIGHT = 20;
    private static int CHANNEL_X = 58;
    private static int CHANNEL_Y = 25;
    private static int CHANNEL_WIDTH = 42;
    private static int CHANNEL_HEIGHT = 15;
    private static int BUTTONS_OFFSET_X = 0;
    private static int BUTTONS_OFFSET_Y = 22;
    private static int BUTTONS_OFFSET = 4;
    private WidgetArrowedListField<String> fieldChannel;
    private WidgetScrollBar scrollBar;
    private WidgetTextFieldExtended fieldSearch;
    private ButtonImage buttonSetDefaults;
    private int firstRow;
    private boolean initialized;
    protected final Set<Slot> terminalDragSplittingSlots = Sets.newHashSet();
    protected boolean terminalDragSplitting;
    private int terminalDragMode;
    private int terminalDragSplittingButton;
    private int terminalDragSplittingRemnant;
    private boolean clicked;
    protected boolean swallowNextCharacter = false;
    private int lastMouseX;
    private int lastMouseY;

    public ContainerScreenTerminalStorage(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
        ((ContainerTerminalStorageBase)((Object)container)).selectedClientTabProvider = this;
    }

    @Override
    public void init() {
        this.clearWidgets();
        super.init();
        this.initialized = false;
        this.fieldChannel = new WidgetArrowedListField(Minecraft.getInstance().font, this.leftPos + CHANNEL_X, this.topPos + CHANNEL_Y, CHANNEL_WIDTH, CHANNEL_HEIGHT, true, (Component)Component.translatable((String)"gui.integratedterminals.channel"), true, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getChannelStrings());
        this.fieldChannel.setMaxLength(15);
        this.fieldChannel.setVisible(true);
        this.fieldChannel.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.fieldChannel.setCanLoseFocus(true);
        this.fieldChannel.setEditable(true);
        int activeChannel = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel();
        if (activeChannel != -1) {
            this.fieldChannel.setValue(Integer.toString(activeChannel));
        }
        this.firstRow = 0;
        this.scrollBar = new WidgetScrollBar(this.leftPos + this.getGridXSize() + 33, this.topPos + SCROLL_Y + 1, this.getScrollHeight() - 2, (Component)Component.empty(), firstRow -> {
            this.firstRow = firstRow;
        }, 0){

            public int getTotalRows() {
                Object container = ContainerScreenTerminalStorage.this.getMenu();
                Optional<ITerminalStorageTabClient<?>> tabOptional = ContainerScreenTerminalStorage.this.getSelectedClientTab();
                if (!tabOptional.isPresent()) {
                    return 0;
                }
                int totalSlots = tabOptional.get().getSlotCount(((ContainerTerminalStorageBase)((Object)container)).getSelectedChannel());
                return (int)Math.ceil((double)totalSlots / (double)ContainerScreenTerminalStorage.this.getSlotRowLength());
            }

            public int getVisibleRows() {
                return ContainerScreenTerminalStorage.this.getSlotVisibleRows();
            }
        };
        this.addWidget((GuiEventListener)this.scrollBar);
        this.fieldSearch = new WidgetTextFieldExtended(Minecraft.getInstance().font, this.leftPos + SEARCH_X, this.topPos + SEARCH_Y, this.getSearchWidth() - 10, SEARCH_HEIGHT, (Component)Component.translatable((String)"gui.cyclopscore.search"));
        this.fieldSearch.setMaxLength(50);
        this.fieldSearch.setVisible(true);
        this.fieldSearch.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.fieldSearch.setCanLoseFocus(true);
        this.fieldSearch.setEditable(true);
        this.fieldSearch.setBordered(false);
        this.buttonSetDefaults = (ButtonImage)this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos + 32 + this.getGridXSize() / 2 + this.getPlayerInventoryOffsetX() + 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + 27, this.topPos + this.getGridYSize() + this.getPlayerInventoryOffsetY() + 120, 15, 15, (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.setdefaults"), this.createServerPressable("button_set_defaults", b -> {}), true, (IImage)Images.ANVIL, -2, -3));
        this.repositionInventorySlots();
    }

    public void repositionInventorySlots() {
        Slot slot;
        int x;
        int y;
        int gridXSize = this.getGridXSize();
        int gridYSize = this.getGridYSize();
        int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
        int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
        ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
        for (y = 0; y < 1; ++y) {
            for (x = 0; x < 9; ++x) {
                slot = ((ContainerTerminalStorageBase)this.container).getSlot(x + y * 9 + 0);
                ContainerExtended.setSlotPosX((Slot)slot, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + playerInventoryOffsetX + 19 + x * IModHelpers.get().getGuiHelpers().getSlotSize()));
                ContainerExtended.setSlotPosY((Slot)slot, (int)(this.offsetY + 58 + 63 + gridYSize + playerInventoryOffsetY + y * IModHelpers.get().getGuiHelpers().getSlotSize()));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slot = ((ContainerTerminalStorageBase)this.container).getSlot(x + y * 9 + 9);
                ContainerExtended.setSlotPosX((Slot)slot, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + playerInventoryOffsetX + 19 + x * IModHelpers.get().getGuiHelpers().getSlotSize()));
                ContainerExtended.setSlotPosY((Slot)slot, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + y * IModHelpers.get().getGuiHelpers().getSlotSize()));
            }
        }
        for (y = 0; y < 4; ++y) {
            Slot slot2 = ((ContainerTerminalStorageBase)this.container).getSlot(36 + y);
            ContainerExtended.setSlotPosX((Slot)slot2, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + playerInventoryOffsetX - 19 + y % 2 * IModHelpers.get().getGuiHelpers().getSlotSize()));
            ContainerExtended.setSlotPosY((Slot)slot2, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + 9 + (int)Math.floor(y / 2) * IModHelpers.get().getGuiHelpers().getSlotSize()));
        }
        Slot slot3 = ((ContainerTerminalStorageBase)this.container).getSlot(40);
        ContainerExtended.setSlotPosX((Slot)slot3, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + playerInventoryOffsetX - 10));
        ContainerExtended.setSlotPosY((Slot)slot3, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + 9 + 49));
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    ContainerExtended.setSlotPosX((Slot)((Slot)slot.getLeft()), (int)((Integer)slotPos.getLeft()));
                    ContainerExtended.setSlotPosY((Slot)((Slot)slot.getLeft()), (int)((Integer)slotPos.getRight()));
                }
            });
        });
    }

    public void containerTick() {
        super.containerTick();
        if (!this.initialized && this.getSelectedClientTab().isPresent()) {
            this.initialized = true;
            String filter = this.getSelectedClientTab().get().getInstanceFilter(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel());
            if (filter != null && !"".equals(filter)) {
                this.fieldSearch.setValue(filter);
                this.getSelectedClientTab().get().setInstanceFilter(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), filter);
            }
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/part_terminal_storage.png");
    }

    public int getGridXSize() {
        return this.getSlotRowLength() * IModHelpers.get().getGuiHelpers().getSlotSize();
    }

    public int getGridYSize() {
        return this.getSlotVisibleRows() * IModHelpers.get().getGuiHelpers().getSlotSize();
    }

    public int getScrollHeight() {
        return this.getGridYSize();
    }

    public int getSearchWidth() {
        return this.getBaseXSize() - 7 * IModHelpers.get().getGuiHelpers().getSlotSize() - 2;
    }

    public int getBaseXSize() {
        return 56 + this.getGridXSize();
    }

    public int getBaseYSize() {
        return 135 + this.getGridYSize() + this.getPlayerInventoryOffsetY() + 10;
    }

    protected int getPlayerInventoryOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getPlayerInventoryOffsetX).orElse(0);
    }

    protected int getPlayerInventoryOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getPlayerInventoryOffsetY).orElse(0);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        this.renderBgTab(guiGraphics, f, mouseX, mouseY);
        this.renderBgPlayerInventory(guiGraphics, f, mouseX, mouseY);
        this.fieldChannel.render(guiGraphics, mouseX, mouseY, f);
        this.fieldSearch.render(guiGraphics, mouseX, mouseY, f);
        this.drawTabsBackground(guiGraphics);
        this.drawTabContents(guiGraphics, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), DrawLayer.BACKGROUND, f, this.getGuiLeftTotal() + this.getSlotsOffsetX(), this.getGuiTopTotal() + this.getSlotsOffsetY(), mouseX, mouseY);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, f);
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.getClient().createButton(button.getX(this.leftPos, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.topPos, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                guiButton.render(guiGraphics, mouseX, mouseY, f);
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.getHeight();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    tab.onCommonSlotRender((AbstractContainerScreen)this, guiGraphics, DrawLayer.BACKGROUND, 0.0f, this.leftPos + (Integer)slotPos.getLeft(), this.topPos + (Integer)slotPos.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).index, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
    }

    protected void renderBgTab(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        int tabWidth = this.getGridXSize() + 29;
        int tabHeight = this.getGridYSize() + 40;
        int offset = 21;
        boolean blitOffset = false;
        int cornerSize = 7;
        int columns = this.getSlotRowLength();
        int rows = this.getSlotVisibleRows();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + offset, this.topPos + offset, (float)cornerSize, 0.0f, cornerSize, cornerSize, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + offset + tabWidth - cornerSize, this.topPos + offset, 0.0f, 0.0f, cornerSize, cornerSize, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + offset + tabWidth - cornerSize, this.topPos + offset + tabHeight - cornerSize, (float)(cornerSize * 2), 0.0f, cornerSize, cornerSize, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + offset, this.topPos + offset + tabHeight - cornerSize, (float)(cornerSize * 3), 0.0f, cornerSize, cornerSize, 256, 256);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + offset + cornerSize, this.topPos + offset, cornerSize + 4, 0.0f, 1, cornerSize, 256, 256, tabWidth - cornerSize * 2, cornerSize, -1);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + offset + tabWidth - cornerSize, this.topPos + offset + cornerSize, 0.0f, 4.0f, cornerSize, 1, 256, 256, cornerSize, tabHeight - cornerSize * 2, -1);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + offset + cornerSize, this.topPos + offset + tabHeight - cornerSize, 25.0f, 0.0f, 1, cornerSize, 256, 256, tabWidth - cornerSize * 2, cornerSize, -1);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + offset, this.topPos + offset + cornerSize, cornerSize, 4.0f, cornerSize, 1, 256, 256, cornerSize, tabHeight - cornerSize * 2, -1);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + offset + cornerSize, this.topPos + offset + cornerSize, 0.0f, 3.0f, 1, 1, 256, 256, tabWidth - cornerSize * 2, tabHeight - cornerSize * 2, -1);
        for (int j = 0; j < rows; ++j) {
            int renderRows = Math.min(3, rows - j);
            for (int i = 0; i < columns; ++i) {
                int renderColumns = Math.min(9, columns - i);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + offset + 10 + i * IModHelpers.get().getGuiHelpers().getSlotSize(), this.topPos + offset + 18 + j * IModHelpers.get().getGuiHelpers().getSlotSize(), 80.0f, 34.0f, IModHelpers.get().getGuiHelpers().getSlotSize() * renderColumns, IModHelpers.get().getGuiHelpers().getSlotSize() * renderRows, 256, 256);
                i += renderColumns - 1;
            }
            j += renderRows - 1;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + this.getGridXSize() + 32, this.topPos + SCROLL_Y - 1, 20.0f, 12.0f, 14, 1, 256, 256);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + this.getGridXSize() + 32, this.topPos + SCROLL_Y, 20.0f, 13.0f, 14, 1, 256, 256, 14, this.getScrollHeight() - 2, -1);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + this.getGridXSize() + 32, this.topPos + SCROLL_Y + this.getScrollHeight() - 2, 20.0f, 101.0f, 14, 1, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + SEARCH_X - 1, this.topPos + SEARCH_Y - 2, 28.0f, 0.0f, 1, SEARCH_HEIGHT - 8, 256, 256);
        ContainerScreenTerminalStorage.blitRescalable(guiGraphics, this.texture, this.leftPos + SEARCH_X, this.topPos + SEARCH_Y - 2, 29.0f, 0.0f, 1, SEARCH_HEIGHT - 8, 256, 256, this.getSearchWidth(), SEARCH_HEIGHT - 8, -1);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + SEARCH_X + this.getSearchWidth() - 1, this.topPos + SEARCH_Y - 2, 117.0f, 0.0f, 1, SEARCH_HEIGHT - 8, 256, 256);
        this.getSelectedClientTab().ifPresent(tab -> tab.onTabBackgroundRender(this, guiGraphics, f, mouseX, mouseY));
    }

    public static void blitRescalable(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int realWidth, int realHeight, int color) {
        guiGraphics.innerBlit(RenderPipelines.GUI_TEXTURED, texture, x, x + realWidth, y, y + realHeight, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, color);
    }

    protected void renderBgPlayerInventory(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + this.getGridXSize() / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + this.getPlayerInventoryOffsetX() + 3, this.topPos + 52 + this.getGridYSize() + this.getPlayerInventoryOffsetY(), 34.0f, 24.0f, 216, 93, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + this.getGridXSize() / 2 + 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + this.getPlayerInventoryOffsetX() + 57, this.topPos + 61 + this.getGridYSize() + this.getPlayerInventoryOffsetY(), 0.0f, 12.0f, 20, 57, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawTabsForeground(guiGraphics, mouseX, mouseY);
        this.drawTabContents(guiGraphics, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), DrawLayer.FOREGROUND, 0.0f, this.getSlotsOffsetX(), this.getSlotsOffsetY(), mouseX, mouseY);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.getClient().createButton(button.getX(this.leftPos, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.topPos, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                if (this.isHovering(button.getX(0, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(0, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), guiButton.getWidth(), guiButton.getHeight(), mouseX, mouseY)) {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(Component.translatable((String)button.getTranslationKey()));
                    button.getTooltip((Player)this.getMinecraft().player, (TooltipFlag)TooltipFlag.Default.NORMAL, lines);
                    this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.getHeight();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    tab.onCommonSlotRender((AbstractContainerScreen)this, guiGraphics, DrawLayer.FOREGROUND, 0.0f, this.leftPos + (Integer)slotPos.getLeft(), this.topPos + (Integer)slotPos.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).index, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
        if (this.buttonSetDefaults.isHoveredOrFocused()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(Component.translatable((String)"gui.integratedterminals.terminal_storage.setdefaults"));
            lines.add(Component.translatable((String)"gui.integratedterminals.terminal_storage.setdefaults.info").withStyle(ChatFormatting.GRAY));
            this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderSlots(GuiGraphics guiGraphics) {
        super.renderSlots(guiGraphics);
        this.drawActiveStorageSlotItem(guiGraphics, this.lastMouseX, this.lastMouseY);
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
        ResourceLocation oldTexture = this.texture;
        this.getSelectedClientTab().ifPresent(tab -> {
            ResourceLocation texture = tab.getBackgroundTexture();
            if (texture != null) {
                this.texture = texture;
            }
        });
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i1 = 0; i1 < ((ContainerTerminalStorageBase)((Object)this.getMenu())).slots.size(); ++i1) {
            Slot slot = (Slot)((ContainerTerminalStorageBase)((Object)this.getMenu())).slots.get(i1);
            if (!slot.isActive()) continue;
            this.drawSlotOverlay(guiGraphics, slot);
        }
        this.texture = oldTexture;
    }

    private void drawSlotOverlay(GuiGraphics guiGraphics, Slot slot) {
        this.getSelectedClientTab().ifPresent(tab -> {
            if (this.terminalDragSplitting && this.terminalDragSplittingSlots.contains(slot)) {
                if (tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) {
                    if (this.terminalDragSplittingSlots.size() == 1) {
                        return;
                    }
                    int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.getItem(), tab.getActiveSlotQuantity());
                    if (dragQuantity > 0) {
                        String dragString = "+" + IModHelpers.get().getGuiHelpers().quantityToScaledString((long)dragQuantity);
                        IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, dragString, this.leftPos + slot.x, this.topPos + slot.y, 0.5f, 0xFFFF55, true, Font.DisplayMode.NORMAL);
                    }
                } else {
                    this.terminalDragSplittingSlots.remove(slot);
                    this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                }
            }
        });
    }

    public C getMenu() {
        return (C)((Object)((ContainerTerminalStorageBase)super.getMenu()));
    }

    protected Optional<ITerminalStorageTabClient<?>> getTabByIndex(int tabIndex) {
        Collection<ITerminalStorageTabClient<?>> tabsClientList = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values();
        if (tabIndex >= 0 && tabIndex < tabsClientList.size()) {
            return Optional.of((ITerminalStorageTabClient)Iterables.get(tabsClientList, (int)tabIndex));
        }
        return Optional.empty();
    }

    protected void setTabByIndex(int tabIndex) {
        this.getTabByIndex(tabIndex).ifPresent(tab -> {
            ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).setSelectedTab(tab.getName().toString());
            tab.resetActiveSlot();
            this.fieldSearch.setValue(tab.getInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel()));
        });
        this.scrollBar.scrollTo(0.0f);
        this.init();
    }

    protected void playButtonClickSound() {
        this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        this.clicked = true;
        if (mouseButton == 0 && mouseY < (double)(this.getGuiTop() + TAB_UNSELECTED_HEIGHT) && mouseX > (double)(this.getGuiLeft() + TAB_OFFSET_X) && mouseX <= (double)(this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() - 1))) {
            this.setTabByIndex((int)((mouseX - (double)TAB_OFFSET_X - (double)this.getGuiLeft()) / (double)TAB_WIDTH));
            this.playButtonClickSound();
            return true;
        }
        if (this.fieldChannel.mouseClicked(mouseX, mouseY, mouseButton)) {
            int channel;
            try {
                channel = Integer.parseInt((String)this.fieldChannel.getActiveElement());
            }
            catch (NumberFormatException e) {
                channel = -1;
            }
            int finalChannel = channel;
            ((ContainerTerminalStorageBase)((Object)this.getMenu())).setSelectedChannel(channel);
            this.scrollBar.scrollTo(0.0f);
            tabOptional.ifPresent(tab -> this.fieldSearch.setValue(tab.getInstanceFilter(finalChannel)));
            this.playButtonClickSound();
            return true;
        }
        if (tabOptional.isPresent()) {
            ITerminalStorageTabClient<?> tab2 = tabOptional.get();
            Slot playerSlot = this.getSlotUnderMouse();
            if (!(tab2.getActiveSlotId() < 0 || mouseButton != 0 && mouseButton != 1 && this.getMinecraft().options.keyPickItem.getKey().getValue() != mouseButton - 100 || playerSlot == null || this.terminalDragSplitting)) {
                this.terminalDragSplitting = true;
                this.terminalDragSplittingButton = mouseButton;
                this.terminalDragSplittingSlots.clear();
                if (mouseButton == 0) {
                    this.terminalDragMode = 0;
                } else if (mouseButton == 1) {
                    this.terminalDragMode = 1;
                } else if (this.getMinecraft().options.keyPickItem.getKey().getValue() == mouseButton - 100) {
                    this.terminalDragMode = 2;
                }
                return true;
            }
            if (IModHelpers.get().getMinecraftClientHelpers().isShifted() && playerSlot != null && tab2.isQuickMovePrevented(playerSlot)) {
                return true;
            }
        } else if (this.getSlotUnderMouse() != null) {
            return false;
        }
        this.fieldSearch.mouseClicked(mouseX, mouseY, mouseButton);
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getTabCommon(tab.getName().toString());
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.getClient().createButton(button.getX(this.leftPos, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.topPos, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                if (this.isHovering(button.getX(0, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(0, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), guiButton.getWidth(), guiButton.getHeight(), mouseX, mouseY)) {
                    button.getClient().onClick(tab, tabCommon, guiButton, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), mouseButton);
                    this.clicked = false;
                    this.playButtonClickSound();
                    return;
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.getHeight();
            }
        });
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot != null && slot.x < 0) {
            return null;
        }
        return slot;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.getSelectedClientTab().map(tab -> {
            Slot slot;
            if (this.terminalDragSplitting & tab.getActiveSlotId() >= 0 && (slot = this.getSlotUnderMouse()) != null && (tab.getActiveSlotQuantity() > this.terminalDragSplittingSlots.size() || this.terminalDragMode == 2) && tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) {
                this.terminalDragSplittingSlots.add(slot);
                this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            return true;
        }
        return this.getFocused() != null && this.isDragging() && mouseButton == 0 && this.getFocused().mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    private void updateTerminalDragSplitting(ITerminalStorageTabClient<?> tab) {
        if (this.terminalDragSplitting) {
            int quantityTotal = tab.getActiveSlotQuantity();
            this.terminalDragSplittingRemnant = tab.getActiveSlotQuantity();
            for (Slot slot : this.terminalDragSplittingSlots) {
                if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot)) continue;
                int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.getItem(), quantityTotal);
                this.terminalDragSplittingRemnant -= tab.dragIntoSlot((AbstractContainerMenu)this.container, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, dragQuantity, true);
            }
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.terminalDragSplitting && (this.terminalDragSplittingSlots.size() <= 1 || this.terminalDragSplittingButton != mouseButton)) {
            this.terminalDragSplitting = false;
            this.terminalDragSplittingSlots.clear();
            if (this.terminalDragSplittingButton != mouseButton) {
                return true;
            }
        }
        boolean dragged = false;
        if (this.terminalDragSplitting) {
            dragged = true;
            this.getSelectedClientTab().ifPresent(tab -> {
                if (tab.getActiveSlotQuantity() > 0) {
                    int quantityTotal;
                    int quantity = quantityTotal = tab.getActiveSlotQuantity();
                    for (Slot slot : this.terminalDragSplittingSlots) {
                        if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) continue;
                        int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.getItem(), quantityTotal);
                        quantity -= tab.dragIntoSlot((AbstractContainerMenu)this.container, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot, dragQuantity, false);
                    }
                    tab.setActiveSlotQuantity(quantity);
                }
            });
        }
        this.terminalDragSplitting = false;
        this.terminalDragSplittingSlots.clear();
        this.terminalDragSplittingButton = -1;
        this.terminalDragMode = -1;
        this.terminalDragSplittingRemnant = 0;
        if (!dragged && this.clicked) {
            this.clicked = false;
            Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
            if (tabOptional.isPresent()) {
                int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
                Slot playerSlot = this.getSlotUnderMouse();
                boolean hasClickedOutside = this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, mouseButton);
                boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
                if (tabOptional.get().handleClick((AbstractContainerMenu)this.getMenu(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, mouseButton, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.index : -1, false)) {
                    return true;
                }
            }
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        if (tabOptional.isPresent()) {
            int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
            Slot playerSlot = this.getSlotUnderMouse();
            boolean hasClickedOutside = this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, 0);
            boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
            if (tabOptional.get().handleScroll((AbstractContainerMenu)this.getMenu(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, delta, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.index : -1)) {
                return true;
            }
        }
        return this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseScrolled(mouseX, mouseY, mouseZ, delta)).isPresent();
    }

    protected boolean handleKeyCodeFirst(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(inputCode)) {
            this.fieldSearch.setFocused(true);
            this.swallowNextCharacter = true;
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_NEXT.isActiveAndMatches(inputCode)) {
            if (((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() > 0) {
                this.setTabByIndex((this.getSelectedClientTabIndex() + 1) % ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount());
                this.playButtonClickSound();
                return true;
            }
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_PREVIOUS.isActiveAndMatches(inputCode) && ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() > 0) {
            this.setTabByIndex((((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() + this.getSelectedClientTabIndex() - 1) % ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount());
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    protected boolean handleKeyCodeLast(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARPLAYER.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(false);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARSTORAGE.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(true);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_BALANCE.isActiveAndMatches(inputCode)) {
            this.balanceCraftingGrid();
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    public boolean charTyped(char keyCode, int scanCode) {
        if (this.swallowNextCharacter) {
            this.swallowNextCharacter = false;
            return true;
        }
        if (this.handleKeyCodeFirst(keyCode, scanCode)) {
            return true;
        }
        if (this.fieldSearch.isFocused()) {
            if (this.fieldSearch.charTyped(keyCode, scanCode)) {
                this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), this.fieldSearch.getValue()));
            }
            return true;
        }
        return this.handleKeyCodeLast(keyCode, scanCode) || super.charTyped(keyCode, scanCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256) {
            if (this.handleKeyCodeFirst(keyCode, scanCode)) {
                return true;
            }
            if (this.fieldSearch.isFocused()) {
                if (this.fieldSearch.keyPressed(keyCode, scanCode, modifiers)) {
                    this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), this.fieldSearch.getValue()));
                }
                return true;
            }
            if (this.handleKeyCodeLast(keyCode, scanCode)) {
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void clearCraftingGrid(boolean toStorage) {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            TerminalButtonItemStackCraftingGridClear.clearGrid((TerminalStorageTabIngredientComponentItemStackCraftingCommon)commonTab, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), toStorage);
        }
    }

    protected void balanceCraftingGrid() {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridBalance(commonTab.getName().toString()));
        }
    }

    private boolean hasClickedInStorage(double mouseX, double mouseY) {
        return mouseX >= (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX()) && mouseX < (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX() + this.getSlotRowLength() * IModHelpers.get().getGuiHelpers().getSlotSize() - 1) && mouseY >= (double)(this.getGuiTopTotal() + this.getSlotsOffsetY()) && mouseY < (double)(this.getGuiTopTotal() + this.getSlotsOffsetY() + this.getSlotVisibleRows() * IModHelpers.get().getGuiHelpers().getSlotSize());
    }

    public int getStorageSlotIndexAtPosition(double mouseX, double mouseY) {
        if (this.hasClickedInStorage(mouseX, mouseY) && (mouseX - (double)this.getGuiLeftTotal() - (double)this.getSlotsOffsetX()) % (double)IModHelpers.get().getGuiHelpers().getSlotSize() < (double)IModHelpers.get().getGuiHelpers().getSlotSizeInner() && (mouseY - (double)this.getGuiTopTotal() - (double)this.getSlotsOffsetY()) % (double)IModHelpers.get().getGuiHelpers().getSlotSize() < (double)IModHelpers.get().getGuiHelpers().getSlotSizeInner()) {
            int rowLength = this.getSlotRowLength();
            int offset = this.getSelectedFirstRow() * rowLength;
            return offset + ((int)mouseX - this.getGuiLeftTotal() - this.getSlotsOffsetX()) / IModHelpers.get().getGuiHelpers().getSlotSize() + ((int)mouseY - this.getGuiTopTotal() - this.getSlotsOffsetY()) / IModHelpers.get().getGuiHelpers().getSlotSize() * this.getSlotRowLength();
        }
        return -1;
    }

    public Rect2i getStorageSlotRect(int slotIndex) {
        int rowLength = this.getSlotRowLength();
        int offset = this.getSelectedFirstRow() * rowLength;
        int visibleIndex = slotIndex - offset;
        int xIndex = visibleIndex % rowLength;
        int yIndex = visibleIndex / rowLength;
        int x = this.getGuiLeftTotal() + this.getSlotsOffsetX() + xIndex * IModHelpers.get().getGuiHelpers().getSlotSize() + 1;
        int y = this.getGuiTopTotal() + this.getSlotsOffsetY() + yIndex * IModHelpers.get().getGuiHelpers().getSlotSize() + 1;
        Rect2i slotRect = new Rect2i(x, y, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner());
        return slotRect;
    }

    protected void drawTabsBackground(GuiGraphics guiGraphics) {
        int offsetX = TAB_OFFSET_X;
        guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.channel", new Object[0]), this.getGuiLeft() + 30, this.getGuiTop() + 26, ARGB.opaque((int)0xFFFFFF));
        for (ITerminalStorageTabClient<?> tab : ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values()) {
            boolean selected = tab.getName().toString().equals(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
            int x = this.getGuiLeft() + offsetX;
            int y = this.getGuiTop();
            int width = TAB_WIDTH;
            int height = selected ? TAB_SELECTED_HEIGHT : TAB_UNSELECTED_HEIGHT;
            int textureX = selected ? TAB_SELECTED_TEXTURE_X : TAB_UNSELECTED_TEXTURE_X;
            int textureY = selected ? TAB_SELECTED_TEXTURE_Y : TAB_UNSELECTED_TEXTURE_Y;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, x, y, (float)textureX, (float)textureY, width, height, 256, 256);
            guiGraphics.renderItem(tab.getIcon(), x + TAB_ICON_OFFSET, y + TAB_ICON_OFFSET);
            offsetX += width;
        }
    }

    protected int getSlotsOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetX).orElse(32);
    }

    protected int getSlotsOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetY).orElse(40);
    }

    protected int getSlotVisibleRows() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotVisibleRows).orElse(5);
    }

    protected int getSlotRowLength() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotRowLength).orElse(9);
    }

    protected int getSelectedFirstRow() {
        return this.firstRow;
    }

    protected void drawTabContents(GuiGraphics guiGraphics, String tabId, int channel, DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getClientTab(tabId);
        if (optionalTab.isPresent()) {
            ITerminalStorageTabClient<?> tab = optionalTab.get();
            if (layer == DrawLayer.BACKGROUND) {
                guiGraphics.drawCenteredString(this.font, tab.getStatus(channel), this.leftPos + 32 + IModHelpers.get().getGuiHelpers().getSlotSize() * tab.getRowColumnProvider().getRowsAndColumns().columns() / 2, y + 2 + this.getSlotVisibleRows() * IModHelpers.get().getGuiHelpers().getSlotSize(), ARGB.opaque((int)0xFFFFFF));
            }
            int rowLength = this.getSlotRowLength();
            int limit = this.getSlotVisibleRows() * rowLength;
            int offset = this.getSelectedFirstRow() * rowLength;
            List<?> slots = tab.getSlots(channel, offset, limit);
            int slotX = x;
            int slotY = y;
            int slotI = 0;
            for (ITerminalStorageSlot slot : slots) {
                if (layer == DrawLayer.BACKGROUND && IModHelpers.get().getRenderHelpers().isPointInRegion(slotX, slotY, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), (double)mouseX, (double)mouseY)) {
                    guiGraphics.fill(slotX, slotY, slotX + IModHelpers.get().getGuiHelpers().getSlotSizeInner(), slotY + IModHelpers.get().getGuiHelpers().getSlotSizeInner(), -2130706433);
                }
                slot.drawGuiContainerLayer((AbstractContainerScreen)this, guiGraphics, layer, partialTick, slotX, slotY, mouseX, mouseY, tab, channel, null);
                if (++slotI >= rowLength) {
                    slotX = x;
                    slotY += IModHelpers.get().getGuiHelpers().getSlotSize();
                    slotI = 0;
                    continue;
                }
                slotX += IModHelpers.get().getGuiHelpers().getSlotSize();
            }
        } else {
            guiGraphics.fill(x - 1, y - 1, x - 1 + IModHelpers.get().getGuiHelpers().getSlotSize() * this.getSlotRowLength(), y - 1 + IModHelpers.get().getGuiHelpers().getSlotSize() * this.getSlotVisibleRows(), IModHelpers.get().getBaseHelpers().RGBAToInt(50, 50, 50, 100));
        }
    }

    private void drawActiveStorageSlotItem(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getSelectedClientTab();
        optionalTab.ifPresent(tab -> {
            int slotId = tab.getActiveSlotId();
            if (slotId >= 0) {
                int quantity = tab.getActiveSlotQuantity();
                List slots = tab.getSlots(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slotId, 1);
                if (!slots.isEmpty()) {
                    ITerminalStorageSlot slot = (ITerminalStorageSlot)slots.get(0);
                    if (this.terminalDragSplitting && this.terminalDragSplittingSlots.size() > 1) {
                        quantity = this.terminalDragSplittingRemnant;
                    }
                    Object quantityString = IModHelpers.get().getGuiHelpers().quantityToScaledString((long)quantity);
                    if (quantity == 0) {
                        quantityString = String.valueOf(ChatFormatting.YELLOW) + (String)quantityString;
                    }
                    slot.drawGuiContainerLayer((AbstractContainerScreen)this, guiGraphics, DrawLayer.BACKGROUND, 0.0f, mouseX - this.leftPos - IModHelpers.get().getGuiHelpers().getSlotSizeInner() / 4, mouseY - this.topPos - IModHelpers.get().getGuiHelpers().getSlotSizeInner() / 4, mouseX, mouseY, (ITerminalStorageTabClient)tab, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), (String)quantityString);
                }
            }
        });
    }

    protected Optional<ITerminalStorageTabClient<?>> getClientTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().get(tab));
    }

    protected Optional<ITerminalStorageTabCommon> getCommonTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsCommon().get(tab));
    }

    @Override
    public Optional<ITerminalStorageTabClient<?>> getSelectedClientTab() {
        return this.getClientTab(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
    }

    protected int getSelectedClientTabIndex() {
        Optional<ITerminalStorageTabClient<?>> selectedTab = this.getSelectedClientTab();
        if (selectedTab.isPresent()) {
            int tabIndex = 0;
            for (ITerminalStorageTabClient<?> tabClient : ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values()) {
                if (tabClient == selectedTab.get()) {
                    return tabIndex;
                }
                ++tabIndex;
            }
        }
        return -1;
    }

    protected void drawTabsForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseY < this.getGuiTop() + TAB_UNSELECTED_HEIGHT && mouseX > this.getGuiLeft() + TAB_OFFSET_X && mouseX <= this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() - 1)) {
            int tabIndex = (mouseX - TAB_OFFSET_X - this.getGuiLeft()) / TAB_WIDTH;
            this.getTabByIndex(tabIndex).ifPresent(tab -> this.drawTooltip(tab.getTooltip(), guiGraphics, mouseX, mouseY));
        }
    }

    public WidgetTextFieldExtended getFieldSearch() {
        return this.fieldSearch;
    }

    public static enum DrawLayer {
        BACKGROUND,
        FOREGROUND;

    }
}

