/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;

public class GuiCraftingPlanFlat
extends AbstractWidget {
    private static final int COLUMNS = 2;
    private static final int COLUMN_PADDING = 2;
    private static final int ELEMENT_WIDTH = 110;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    private static final int ELEMENT_HEIGHT_MAX = 178;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlanFlat(AbstractContainerScreen parentGui, ITerminalCraftingPlanFlat<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 110, 178, (Component)Component.literal((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlanFlat.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.refreshList();
        this.label = IModHelpers.get().getL10NHelpers().localize(craftingPlan.getUnlocalizedLabel(), new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlanFlat guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        this.refreshList();
    }

    protected void refreshList() {
        this.scrollBar.setTotalRows((int)Math.ceil(this.visibleElements.size() / 2));
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    public void drawGuiContainerLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        int column = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(guiGraphics, element, guiLeft + this.getX() + column * 112, guiTop + this.getY() + offsetY, 110 + (column == 0 ? 1 : 0), 16, layer, partialTick, mouseX, mouseY);
            if (++column < 2) continue;
            column = 0;
            offsetY += 18;
        }
    }

    private void drawElement(GuiGraphics guiGraphics, Element element, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            guiGraphics.fill(x, y, x + width, y + height + 1, element.getColor());
        }
        int xOriginal = x;
        IPrototypedIngredient<?, ?> output = element.getInstance();
        IngredientComponent ingredientComponent = output.getComponent();
        long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
        int finalX = x;
        int finalY = y;
        ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).ifPresent(h -> h.getClient().drawInstance(guiGraphics, output.getPrototype(), quantity, "", this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            int moved = 0;
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CHEST), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.stored", new Object[]{element.getStorageQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getToCraftQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.to_craft", new Object[]{element.getToCraftQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getCraftingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.crafting", new Object[]{element.getCraftingQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getMissingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.BARRIER), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.missing", new Object[]{element.getMissingQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            }
        }
    }

    protected static void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float scale) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y);
        guiGraphics.pose().scale(scale, scale);
        GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
        guiGraphics.renderItem(itemStack, 0, 0);
        renderItem.renderItemDecorations(Minecraft.getInstance().font, itemStack, 0, 0, "");
        guiGraphics.pose().popMatrix();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / (long)IModHelpers.get().getMinecraftHelpers().getSecondInTicks();
        return IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.duration", new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.label, this.guiLeft + this.getX() + 110 + 8, this.guiTop + this.getY() - 13, ARGB.opaque((int)0xFFFFFF));
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlanFlat.getDurationString(this.tickDuration);
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, durationString, this.guiLeft + this.getX() + 200, this.guiTop + this.getY() - 14, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        if (this.channel != -1) {
            String channelString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", new Object[]{this.channel});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, channelString, this.guiLeft + this.getX() + 200, this.guiTop + this.getY() - 8, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        if (this.initiatorName != null) {
            String initiatorString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.owner", new Object[]{this.initiatorName});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, initiatorString, this.guiLeft + this.getX() - 4, this.guiTop + this.getY() - 14, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        this.drawGuiContainerLayer(guiGraphics, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(guiGraphics, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scroll) {
        return this.scrollBar.mouseScrolled(mouseX, mouseY, mouseZ, scroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.mouseDragged(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlanFlat<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        for (ITerminalCraftingPlanFlat.IEntry entry : craftingPlan.getEntries()) {
            GuiCraftingPlanFlat.addElements(entry, elements);
        }
        return elements;
    }

    protected static void addElements(ITerminalCraftingPlanFlat.IEntry craftingPlan, List<Element> elements) {
        elements.add(new Element(craftingPlan.getInstance(), craftingPlan.getQuantityInStorage(), craftingPlan.getQuantityToCraft(), craftingPlan.getQuantityCrafting(), craftingPlan.getQuantityMissing()));
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static class Element {
        private final IPrototypedIngredient<?, ?> instance;
        private final long storageQuantity;
        private final long toCraftQuantity;
        private final long craftingQuantity;
        private final long missingQuantity;

        public Element(IPrototypedIngredient<?, ?> instance, long storageQuantity, long toCraftQuantity, long craftingQuantity, long missingQuantity) {
            this.instance = instance;
            this.storageQuantity = storageQuantity;
            this.toCraftQuantity = toCraftQuantity;
            this.craftingQuantity = craftingQuantity;
            this.missingQuantity = missingQuantity;
        }

        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getToCraftQuantity() {
            return this.toCraftQuantity;
        }

        public long getCraftingQuantity() {
            return this.craftingQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            if (this.getMissingQuantity() > 0L) {
                return IModHelpers.get().getBaseHelpers().RGBAToInt(250, 10, 13, 150);
            }
            if (this.getCraftingQuantity() > 0L) {
                return IModHelpers.get().getBaseHelpers().RGBAToInt(43, 174, 231, 150);
            }
            if (this.getToCraftQuantity() > 0L) {
                return IModHelpers.get().getBaseHelpers().RGBAToInt(243, 245, 150, 150);
            }
            return IModHelpers.get().getBaseHelpers().RGBAToInt(43, 231, 47, 150);
        }
    }
}

