/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButtonClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonFilterCraftingClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonFilterCrafting<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> {
    protected final TerminalStorageState state;
    protected final String buttonName;
    protected final ITerminalStorageTabClient<?> clientTab;
    protected FilterType active;

    public TerminalButtonFilterCrafting(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "filter_crafting";
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public ITerminalButtonClient<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> getClient() {
        return new TerminalButtonFilterCraftingClient(this);
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = FilterType.values()[(Integer)data.getInt("active").orElseThrow()];
        } else {
            this.active = FilterType.ALL;
        }
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.crafting.filter";
    }

    @Override
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.crafting.filter.info").withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)this.active.getLabel()));
    }

    public Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<T>> getEffectiveFilter() {
        return this.active.getFilter();
    }

    public static enum FilterType {
        ALL((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_ALL, "gui.integratedterminals.terminal_storage.crafting.filter.type.all", i -> true),
        STORAGE((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_STORAGE, "gui.integratedterminals.terminal_storage.crafting.filter.type.storage", i -> i.getCraftingOption() == null),
        CRAFTABLE((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_CRAFTABLE, "gui.integratedterminals.terminal_storage.crafting.filter.type.craftable", i -> i.getCraftingOption() != null);

        @Nullable
        private final IImage image;
        private final String label;
        private final Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> filter;

        private FilterType(IImage image, String label, Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> filter) {
            this.image = image;
            this.label = label;
            this.filter = filter;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }

        public Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> getFilter() {
            return this.filter;
        }
    }
}

