/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.query;

import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.core.terminalstorage.query.IIngredientQuery;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientQueryLeaf<T>
implements IIngredientQuery<T> {
    private final Predicate<T> tester;

    public IngredientQueryLeaf(String query, IIngredientComponentTerminalStorageHandler<T, ?> handler) {
        Pair<SearchMode, String> parsed = IngredientQueryLeaf.parseQuery(query);
        this.tester = handler.getClient().getInstanceFilterPredicate((SearchMode)((Object)parsed.getLeft()), (String)parsed.getRight());
    }

    public static Pair<SearchMode, String> parseQuery(String query) {
        if (!query.isEmpty()) {
            char c = query.charAt(0);
            switch (c) {
                case '@': {
                    return Pair.of((Object)((Object)SearchMode.MOD), (Object)query.substring(1));
                }
                case '$': {
                    return Pair.of((Object)((Object)SearchMode.TOOLTIP), (Object)query.substring(1));
                }
                case '#': {
                    return Pair.of((Object)((Object)SearchMode.TAG), (Object)query.substring(1));
                }
            }
        }
        return Pair.of((Object)((Object)SearchMode.DEFAULT), (Object)query);
    }

    @Override
    public boolean test(T t) {
        try {
            return this.tester.test(t);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

