/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.PacketCodecs;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypes;

public class TerminalStorageIngredientPartOpenPacket
extends PacketCodec<TerminalStorageIngredientPartOpenPacket> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientPartOpenPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_part_open"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientPartOpenPacket> CODEC = TerminalStorageIngredientPartOpenPacket.getCodec(TerminalStorageIngredientPartOpenPacket::new);
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;

    public TerminalStorageIngredientPartOpenPacket() {
        super(ID);
    }

    public TerminalStorageIngredientPartOpenPacket(BlockPos pos, Direction side, String tabName, int channel) {
        super(ID);
        this.pos = pos;
        this.side = side;
        this.tabName = tabName;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        TerminalStorageIngredientPartOpenPacket.openServer(world, this.pos, this.side, player, this.tabName, this.channel);
    }

    public static void openServer(Level world, BlockPos pos, Direction side, ServerPlayer player, String tabName, int channel) {
        final ContainerTerminalStorageBase.InitTabData initData = new ContainerTerminalStorageBase.InitTabData(tabName, channel);
        PartPos partPos = PartPos.of((Level)world, (BlockPos)pos, (Direction)side);
        final Triple data = PartHelpers.getContainerPartConstructionData((PartPos)partPos);
        PartTypeTerminalStorage.State state = (PartTypeTerminalStorage.State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
        final TerminalStorageState terminalStorageState = state.getPlayerStorageState((Player)player);
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStoragePart(id, playerInventory, (PartTarget)data.getRight(), (PartTypeTerminalStorage)((Object)data.getMiddle()), Optional.of(initData), terminalStorageState);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
        player.openMenu(containerProvider, packetBuffer -> {
            PacketCodecs.write((RegistryFriendlyByteBuf)packetBuffer, (Object)partPos);
            packetBuffer.writeUtf(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            packetBuffer.writeBoolean(true);
            initData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
            terminalStorageState.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    public static void send(BlockPos pos, Direction side, String tabName, int channel) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientPartOpenPacket(pos, side, tabName, channel));
    }
}

