/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;

public class ContainerTerminalStoragePart
extends ContainerTerminalStorageBase<PartPos> {
    private final PartTarget target;
    private final Optional<IPartContainer> partContainer;
    private final PartTypeTerminalStorage partType;

    public ContainerTerminalStoragePart(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((FriendlyByteBuf)packetBuffer), (PartTypeTerminalStorage)PartHelpers.readPart((FriendlyByteBuf)packetBuffer), packetBuffer.readBoolean() ? Optional.of(ContainerTerminalStorageBase.InitTabData.readFromPacketBuffer(packetBuffer)) : Optional.empty(), TerminalStorageState.readFromPacketBuffer(packetBuffer));
        this.getGuiState().setDirtyMarkListener(this::sendGuiStateToServer);
    }

    public ContainerTerminalStoragePart(int id, Inventory playerInventory, PartTarget target, PartTypeTerminalStorage partType, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        this(RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_PART, id, playerInventory, target, Optional.of((IPartContainer)PartHelpers.getPartContainer((DimPos)target.getCenter().getPos(), (Direction)target.getCenter().getSide()).orElseThrow(() -> new IllegalStateException("Could not find part container"))), partType, initTabData, terminalStorageState);
    }

    public ContainerTerminalStoragePart(@Nullable MenuType<?> type, int id, Inventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalStorage partType, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        super(type, id, playerInventory, initTabData, terminalStorageState, NetworkHelpers.getNetwork((PartPos)target.getCenter()).map(a -> a), partContainer.map(p -> (PartTypeTerminalStorage.State)p.getPartState(target.getCenter().getSide())));
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.putButtonAction("button_settings", (s, containerExtended) -> {
            if (!this.getWorld().m_5776_()) {
                PartHelpers.openContainerPart((ServerPlayer)((ServerPlayer)this.player), (PartPos)target.getCenter(), (IPartType)partType);
            }
        });
    }

    public PartTypeTerminalStorage getPartType() {
        return this.partType;
    }

    public PartTarget getPartTarget() {
        return this.target;
    }

    public Optional<PartTypeTerminalStorage.State> getPartState() {
        return this.partContainer.map(p -> (PartTypeTerminalStorage.State)p.getPartState(this.getPartTarget().getCenter().getSide()));
    }

    public Optional<IPartContainer> getPartContainer() {
        return this.partContainer;
    }

    public boolean m_6875_(Player playerIn) {
        return PartHelpers.canInteractWith((PartTarget)this.getPartTarget(), (Player)this.player, (IPartContainer)this.partContainer.get());
    }

    @Override
    public ITerminalStorageLocation<PartPos> getLocation() {
        return TerminalStorageLocations.PART;
    }

    @Override
    public PartPos getLocationInstance() {
        return this.getPartTarget().getCenter();
    }

    @Override
    public void onVariableContentsUpdated(INetwork network, IVariable<?> variable) {
        try {
            IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked((INetwork)network);
            MinecraftForge.EVENT_BUS.post((Event)new PartVariableDrivenVariableContentsUpdatedEvent(network, partNetwork, this.getPartTarget(), (IPartType)this.getPartType(), (IPartState)this.getPartState().get(), this.player, variable, variable != null ? variable.getValue() : null));
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }
}

