/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeTransferHelpers;
import org.cyclops.integratedterminalscompat.modcompat.jei.JEIIntegratedTerminalsConfig;
import org.cyclops.integratedterminalscompat.modcompat.jei.RecipeInputSlotJei;
import org.cyclops.integratedterminalscompat.modcompat.jei.RecipeTransferErrorTransferResult;

public class TerminalStorageRecipeTransferHandler<T extends ContainerTerminalStorageBase<?>>
implements IRecipeTransferHandler<T, CraftingRecipe> {
    private final Class<T> clazz;
    private final MenuType<T> menuType;
    private int previousChangeId;

    public TerminalStorageRecipeTransferHandler(Class<T> clazz, MenuType<T> menuType) {
        this.clazz = clazz;
        this.menuType = menuType;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, CraftingRecipe recipe, IRecipeSlotsView recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (Objects.equals(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab(), TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
            ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)((Object)container)).getTabCommon(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab());
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            if (!doTransfer) {
                TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)((ContainerTerminalStorageBase)((Object)container)).getTabClient(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab());
                return this.getMissingItems(container, recipe, recipeLayout, player, tabCommonCrafting, tabClient).orElse(null);
            }
            RecipeTransferHelpers.transferRecipe(container, this.getRecipeInputSlots(recipeLayout), player, tabCommonCrafting, JEIIntegratedTerminalsConfig::getItemStackMatchCondition, maxTransfer);
            return null;
        }
        return new TransferError();
    }

    private Collection<RecipeInputSlotJei> getRecipeInputSlots(IRecipeSlotsView recipeLayout) {
        ArrayList recipeInputSlots = Lists.newArrayList();
        for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
            if (slotView.getRole() == RecipeIngredientRole.INPUT && !slotView.isEmpty() && ((ITypedIngredient)slotView.getAllIngredients().findFirst().get()).getType() != VanillaTypes.ITEM_STACK) continue;
            recipeInputSlots.add(new RecipeInputSlotJei(slotView));
        }
        return recipeInputSlots;
    }

    private Optional<IRecipeTransferError> getMissingItems(T container, CraftingRecipe recipe, IRecipeSlotsView recipeLayout, Player player, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting, TerminalStorageTabIngredientComponentClient<?, ?> tabClient) {
        return RecipeTransferHelpers.getMissingItems(recipe, container, this.getRecipeInputSlots(recipeLayout), player, tabCommonCrafting, tabClient, JEIIntegratedTerminalsConfig::getItemStackMatchCondition, () -> this.previousChangeId, id -> {
            this.previousChangeId = id;
        }).map(RecipeTransferErrorTransferResult::new);
    }

    public static class TransferError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
        }
    }
}

