/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.screen.EmiScreenManager;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.modcompat.common.button.TerminalButtonItemStackCraftingGridSearchSync;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.TerminalStorageEmiRecipeHandler;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.TerminalStorageEmiStackProvider;

@EmiEntrypoint
public class EmiIntegratedTerminalsConfig
implements EmiPlugin {
    private boolean loaded = false;
    private boolean wasEmiVisible = false;

    public EmiIntegratedTerminalsConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static int getItemStackMatchCondition(ItemStack itemStack) {
        Comparison comparison = EmiComparisonDefaults.get((Object)itemStack.m_41720_());
        return comparison == Comparison.DEFAULT_COMPARISON ? 1 : 5;
    }

    public void register(EmiRegistry emiRegistry) {
        this.loaded = true;
        emiRegistry.addRecipeHandler(RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_PART, new TerminalStorageEmiRecipeHandler());
        emiRegistry.addRecipeHandler(RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM, new TerminalStorageEmiRecipeHandler());
        emiRegistry.addGenericStackProvider((EmiStackProvider)new TerminalStorageEmiStackProvider());
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        if (this.loaded && !event.getButtons().stream().anyMatch(button -> button instanceof TerminalButtonItemStackCraftingGridSearchSync)) {
            event.getButtons().add(new TerminalButtonItemStackCraftingGridSearchSync("emi", event.getContainer().getGuiState(), event.getClientTab(), Images.BUTTON_MIDDLE_EMI_SYNC));
        }
    }

    @SubscribeEvent
    public void onTerminalStorageScreenSize(TerminalStorageScreenSizeEvent event) {
        if (this.loaded) {
            try {
                boolean isOpen = !EmiScreenManager.isDisabled();
                boolean wasJeiVisiblePrevious = this.wasEmiVisible;
                if (isOpen) {
                    this.wasEmiVisible = true;
                    event.setHeight(event.getHeight() - 20);
                    event.setWidth(event.getWidth() - 170);
                } else {
                    this.wasEmiVisible = false;
                }
                if (wasJeiVisiblePrevious != this.wasEmiVisible) {
                    ((ContainerScreenTerminalStorage)Minecraft.m_91087_().f_91080_).m_7856_();
                }
            }
            catch (ClassCastException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (!EmiScreenManager.isDisabled() && TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(event.getClientTab())) {
            EmiApi.setSearchText((String)event.getSearchString());
        }
    }

    @SubscribeEvent
    public void onKeyTyped(ScreenEvent.KeyReleased.Post event) {
        if (event.getScreen() instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage gui = (ContainerScreenTerminalStorage)event.getScreen();
            if (!EmiScreenManager.isDisabled() && EmiApi.isSearchFocused()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(tab)) {
                        WidgetTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.m_94144_(EmiApi.getSearchText());
                        tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)gui.getMenu()))).getSelectedChannel(), fieldSearch.m_94155_());
                    }
                });
            }
        }
    }
}

