/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanFlatStatic;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanStatic;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.slf4j.Logger;

public interface ITerminalStorageTabIngredientCraftingHandler<O extends ITerminalCraftingOption<?>, I> {
    public static final Logger LOGGER = LogUtils.getLogger();

    public ResourceLocation getId();

    public <T, M> int[] getChannels(TerminalStorageTabIngredientComponentServer<T, M> var1);

    public <T, M> Collection<O> getCraftingOptions(TerminalStorageTabIngredientComponentServer<T, M> var1, int var2);

    public <T, M> Collection<O> getCraftingOptionsWithOutput(TerminalStorageTabIngredientComponentServer<T, M> var1, int var2, T var3, M var4);

    public void serializeCraftingOption(ValueOutput var1, O var2);

    public <T, M> O deserializeCraftingOption(ValueInput var1, IngredientComponent<T, M> var2) throws IllegalArgumentException;

    public ITerminalCraftingPlan<I> calculateCraftingPlan(INetwork var1, int var2, ITerminalCraftingOption var3, long var4);

    default public void serializeCraftingPlan(ValueOutput valueOutput, ITerminalCraftingPlan<I> craftingPlan) {
        TerminalCraftingPlanStatic.serialize(valueOutput, (TerminalCraftingPlanStatic)craftingPlan, this);
    }

    default public CompoundTag serializeCraftingPlanToNbt(ITerminalCraftingPlan<I> craftingPlan) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);){
            TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)scopedCollector);
            this.serializeCraftingPlan((ValueOutput)valueOutput, craftingPlan);
            CompoundTag compoundTag = valueOutput.buildResult();
            return compoundTag;
        }
    }

    default public ITerminalCraftingPlan<I> deserializeCraftingPlan(ValueInput valueInput) throws IllegalArgumentException {
        return TerminalCraftingPlanStatic.deserialize(valueInput, this);
    }

    default public void serializeCraftingPlanFlat(ValueOutput valueOutput, ITerminalCraftingPlanFlat<I> craftingPlan) {
        TerminalCraftingPlanFlatStatic.serialize(valueOutput, (TerminalCraftingPlanFlatStatic)craftingPlan, this);
    }

    default public ITerminalCraftingPlanFlat<I> deserializeCraftingPlanFlat(ValueInput valueInput) throws IllegalArgumentException {
        return TerminalCraftingPlanFlatStatic.deserialize(valueInput, this);
    }

    public void serializeCraftingJobId(ValueOutput var1, I var2);

    public I deserializeCraftingJobId(ValueInput var1);

    public void startCraftingJob(INetwork var1, int var2, ITerminalCraftingPlan<I> var3, ServerPlayer var4) throws CraftingJobStartException;

    public List<ITerminalCraftingPlan<I>> getCraftingJobs(INetwork var1, int var2);

    @Nullable
    public ITerminalCraftingPlan<I> getCraftingJob(INetwork var1, int var2, I var3);

    public boolean cancelCraftingJob(INetwork var1, int var2, I var3);
}

