/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class HandlerWrappedTerminalCraftingPlan {
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final ITerminalCraftingPlanFlat craftingPlanFlat;

    public HandlerWrappedTerminalCraftingPlan(ITerminalStorageTabIngredientCraftingHandler handler, ITerminalCraftingPlanFlat craftingPlanFlat) {
        this.handler = handler;
        this.craftingPlanFlat = craftingPlanFlat;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public ITerminalCraftingPlanFlat getCraftingPlanFlat() {
        return this.craftingPlanFlat;
    }

    public static CompoundTag serialize(HolderLookup.Provider lookupProvider, HandlerWrappedTerminalCraftingPlan craftingPlan) {
        ITerminalStorageTabIngredientCraftingHandler handler = craftingPlan.getHandler();
        CompoundTag tag = new CompoundTag();
        tag.putString("craftingPlanHandler", handler.getId().toString());
        tag.put("flatPlan", (Tag)IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o -> handler.serializeCraftingPlanFlat((ValueOutput)o, craftingPlan.getCraftingPlanFlat()), lookupProvider));
        return tag;
    }

    public static HandlerWrappedTerminalCraftingPlan deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        String handlerId = (String)tag.getString("craftingPlanHandler").orElseThrow();
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(ResourceLocation.parse((String)handlerId));
        ITerminalCraftingPlanFlat craftingPlanFlat = (ITerminalCraftingPlanFlat)IModHelpers.get().getMinecraftHelpers().valueInputFromNbt((CompoundTag)tag.getCompound("flatPlan").orElseThrow(), lookupProvider, handler::deserializeCraftingPlanFlat);
        return new HandlerWrappedTerminalCraftingPlan(handler, craftingPlanFlat);
    }
}

