/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientItemStackCraftingGridBalance
extends PacketCodec<TerminalStorageIngredientItemStackCraftingGridBalance> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientItemStackCraftingGridBalance> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_itemstack_crafting_grid_balance"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientItemStackCraftingGridBalance> CODEC = TerminalStorageIngredientItemStackCraftingGridBalance.getCodec(TerminalStorageIngredientItemStackCraftingGridBalance::new);
    @CodecField
    private String tabId;

    public TerminalStorageIngredientItemStackCraftingGridBalance() {
        super(ID);
    }

    public TerminalStorageIngredientItemStackCraftingGridBalance(String tabId) {
        super(ID);
        this.tabId = tabId;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ContainerTerminalStorageBase container;
        if (player.containerMenu instanceof ContainerTerminalStorageBase && (container = (ContainerTerminalStorageBase)player.containerMenu).getTabServer(this.tabId) instanceof TerminalStorageTabIngredientComponentServer) {
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)container.getTabCommon(this.tabId);
            tabCommon.getInventoryCraftResult().setItem(0, ItemStack.EMPTY);
            TerminalStorageIngredientItemStackCraftingGridBalance.balanceGrid(tabCommon.getInventoryCrafting());
        }
    }

    public static void balanceGrid(CraftingContainer craftingGrid) {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)craftingGrid.getContainerSize());
        for (int slot = 0; slot < craftingGrid.getContainerSize(); ++slot) {
            ItemStack itemStack = craftingGrid.getItem(slot);
            if (itemStack.isEmpty()) continue;
            int amount = itemStack.getCount();
            itemStack = itemStack.copy();
            itemStack.setCount(1);
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).copy();
                original.setCount(1);
                if (!ItemStack.isSameItemSameComponents((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).grow(amount);
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.setCount(amount);
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).getCount() / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).getCount() % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).copy();
                itemStack.setCount(((Integer)slot.getRight()).intValue());
                craftingGrid.setItem(((Integer)slot.getKey()).intValue(), itemStack);
            }
        }
    }
}

