/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientItemStackCraftingGridShiftClickOutput
extends PacketCodec<TerminalStorageIngredientItemStackCraftingGridShiftClickOutput> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientItemStackCraftingGridShiftClickOutput> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_itemstack_crafting_grid_shift_click_output"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientItemStackCraftingGridShiftClickOutput> CODEC = TerminalStorageIngredientItemStackCraftingGridShiftClickOutput.getCodec(TerminalStorageIngredientItemStackCraftingGridShiftClickOutput::new);
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private boolean craftOnce;

    public TerminalStorageIngredientItemStackCraftingGridShiftClickOutput() {
        super(ID);
    }

    public TerminalStorageIngredientItemStackCraftingGridShiftClickOutput(String tabId, int channel, boolean craftOnce) {
        super(ID);
        this.tabId = tabId;
        this.channel = channel;
        this.craftOnce = craftOnce;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ContainerTerminalStorageBase container;
        ITerminalStorageTabCommon tabCommon;
        if (player.containerMenu instanceof ContainerTerminalStorageBase && (tabCommon = (container = (ContainerTerminalStorageBase)player.containerMenu).getTabCommon(this.tabId)) instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            ITerminalStorageTabCommon.IVariableInventory variableInventory = container.getVariableInventory().get();
            ResultSlot slotCrafting = tabCommonCrafting.getSlotCrafting();
            ItemStack currentCraftingItem = slotCrafting.getItem().copy();
            int craftedAmount = 0;
            while (ItemHandlerHelper.insertItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (ItemStack)slotCrafting.getItem(), (boolean)true).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)currentCraftingItem, (ItemStack)slotCrafting.getItem())) {
                ItemStack resultStack = slotCrafting.remove(64);
                slotCrafting.onTake((Player)player, resultStack);
                craftedAmount += resultStack.getCount();
                if (!resultStack.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(resultStack.copy(), true);
                    tabCommonCrafting.updateCraftingResult((Player)player, player.containerMenu, variableInventory);
                }
                if (!this.craftOnce && !resultStack.isEmpty() && craftedAmount < resultStack.getMaxStackSize()) continue;
            }
        }
    }
}

