/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.slf4j.Logger;

public class TerminalStorageIngredientUpdateActiveStorageIngredientPacket<T>
extends PacketCodec<TerminalStorageIngredientUpdateActiveStorageIngredientPacket<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<TerminalStorageIngredientUpdateActiveStorageIngredientPacket<?>> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_update_active_storage_ingredient"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientUpdateActiveStorageIngredientPacket<?>> CODEC = TerminalStorageIngredientUpdateActiveStorageIngredientPacket.getCodec(TerminalStorageIngredientUpdateActiveStorageIngredientPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag activeStorageInstanceData;

    public TerminalStorageIngredientUpdateActiveStorageIngredientPacket() {
        super(ID);
    }

    public TerminalStorageIngredientUpdateActiveStorageIngredientPacket(HolderLookup.Provider lookupProvider, String tabId, IngredientComponent<T, ?> component, int channel, T activeStorageInstance) {
        super(ID);
        this.tabId = tabId;
        this.ingredientName = component.getName().toString();
        this.channel = channel;
        IIngredientSerializer serializer = this.getComponent().getSerializer();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);){
            TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider);
            serializer.serializeInstance((ValueOutput)valueOutput, activeStorageInstance);
            this.activeStorageInstanceData = valueOutput.buildResult();
        }
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IIngredientSerializer serializer = this.getComponent().getSerializer();
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(this.activeStorageInstanceData), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)this.activeStorageInstanceData);
                Object activeInstance = serializer.deserializeInstance(input);
                tab.handleActiveIngredientUpdate(this.getChannel(), activeInstance);
            }
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }

    public IngredientComponent<T, ?> getComponent() {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)this.ingredientName));
        if (ingredientComponent == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
        }
        return ingredientComponent;
    }

    public int getChannel() {
        return this.channel;
    }
}

