/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanStatic;

public class TerminalCraftingPlanFlatStatic<I>
implements ITerminalCraftingPlanFlat<I> {
    private final I id;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private final List<Entry> entries;
    private TerminalCraftingJobStatus status;
    private TerminalCraftingPlanStatic.Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanFlatStatic(I id, List<Entry> entries, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, TerminalCraftingPlanStatic.Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.entries = entries;
        this.outputs = outputs;
        this.status = status;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    public TerminalCraftingPlanStatic.Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.getUnlocalizedLabelOverride() == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    public static <I> void serialize(ValueOutput valueOutput, TerminalCraftingPlanFlatStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        handler.serializeCraftingJobId(valueOutput, plan.getId());
        ValueOutput.ValueOutputList entries = valueOutput.childrenList("entries");
        for (Entry entry : plan.getEntries()) {
            Entry.serialize(entries.addChild(), entry);
        }
        ValueOutput.ValueOutputList outputs = valueOutput.childrenList("outputs");
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            IPrototypedIngredient.serialize((ValueOutput)outputs.addChild(), (IPrototypedIngredient)((PrototypedIngredient)output));
        }
        valueOutput.putInt("status", plan.getStatus().ordinal());
        valueOutput.putInt("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            valueOutput.putString("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        valueOutput.putLong("tickDuration", plan.getTickDuration());
        valueOutput.putInt("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            valueOutput.putString("initiatorName", plan.getInitiatorName());
        }
    }

    public static <I> TerminalCraftingPlanFlatStatic<I> deserialize(ValueInput valueInput, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        I id = handler.deserializeCraftingJobId(valueInput);
        ArrayList entries = Lists.newArrayList();
        for (Object nbtBase : (ValueInput.ValueInputList)valueInput.childrenList("entries").orElseThrow()) {
            entries.add(Entry.deserialize((ValueInput)nbtBase));
        }
        ArrayList outputs = Lists.newArrayList();
        for (ValueInput nbtBase : (ValueInput.ValueInputList)valueInput.childrenList("outputs").orElseThrow()) {
            outputs.add(IPrototypedIngredient.deserialize((ValueInput)nbtBase));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[(Integer)valueInput.getInt("status").orElseThrow()];
        TerminalCraftingPlanStatic.Label label = TerminalCraftingPlanStatic.Label.values()[(Integer)valueInput.getInt("label").orElseThrow()];
        String unlocalizedLabelOverride = valueInput.getStringOr("unlocalizedLabelOverride", null);
        long tickDuration = (Long)valueInput.getLong("tickDuration").orElseThrow();
        int channel = (Integer)valueInput.getInt("channel").orElseThrow();
        String initiatorName = valueInput.getStringOr("initiatorName", null);
        TerminalCraftingPlanFlatStatic<I> plan = new TerminalCraftingPlanFlatStatic<I>(id, entries, outputs, status, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static class Entry
    implements ITerminalCraftingPlanFlat.IEntry {
        private final IPrototypedIngredient<?, ?> instance;
        private long quantityToCraft;
        private long quantityCrafting;
        private long quantityInStorage;
        private long quantityMissing;

        public Entry(IPrototypedIngredient<?, ?> instance, long quantityToCraft, long quantityCrafting, long quantityInStorage, long quantityMissing) {
            this.instance = instance;
            this.quantityToCraft = quantityToCraft;
            this.quantityCrafting = quantityCrafting;
            this.quantityInStorage = quantityInStorage;
            this.quantityMissing = quantityMissing;
        }

        public Entry(IPrototypedIngredient<?, ?> instance) {
            this(instance, 0L, 0L, 0L, 0L);
        }

        @Override
        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        @Override
        public long getQuantityToCraft() {
            return this.quantityToCraft;
        }

        public void setQuantityToCraft(long quantityToCraft) {
            this.quantityToCraft = quantityToCraft;
        }

        @Override
        public long getQuantityCrafting() {
            return this.quantityCrafting;
        }

        public void setQuantityCrafting(long quantityCrafting) {
            this.quantityCrafting = quantityCrafting;
        }

        @Override
        public long getQuantityInStorage() {
            return this.quantityInStorage;
        }

        public void setQuantityInStorage(long quantityInStorage) {
            this.quantityInStorage = quantityInStorage;
        }

        @Override
        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public void setQuantityMissing(long quantityMissing) {
            this.quantityMissing = quantityMissing;
        }

        public static void serialize(ValueOutput valueOutput, Entry entry) {
            IPrototypedIngredient.serialize((ValueOutput)valueOutput.child("instance"), entry.getInstance());
            valueOutput.putLong("quantityToCraft", entry.getQuantityToCraft());
            valueOutput.putLong("quantityCrafting", entry.getQuantityCrafting());
            valueOutput.putLong("quantityInStorage", entry.getQuantityInStorage());
            valueOutput.putLong("quantityMissing", entry.getQuantityMissing());
        }

        public static Entry deserialize(ValueInput valueInput) {
            PrototypedIngredient instance = IPrototypedIngredient.deserialize((ValueInput)((ValueInput)valueInput.child("instance").orElseThrow()));
            long quantityToCraft = (Long)valueInput.getLong("quantityToCraft").orElseThrow();
            long quantityCrafting = (Long)valueInput.getLong("quantityCrafting").orElseThrow();
            long quantityInStorage = (Long)valueInput.getLong("quantityInStorage").orElseThrow();
            long quantityMissing = (Long)valueInput.getLong("quantityMissing").orElseThrow();
            return new Entry((IPrototypedIngredient<?, ?>)instance, quantityToCraft, quantityCrafting, quantityInStorage, quantityMissing);
        }
    }
}

