/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridBalance;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridShiftClickOutput;

public class TerminalStorageTabIngredientComponentItemStackCraftingClient
extends TerminalStorageTabIngredientComponentClient<ItemStack, Integer> {
    private final ItemStack icon = new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);

    public TerminalStorageTabIngredientComponentItemStackCraftingClient(ContainerTerminalStorageBase container, ResourceLocation name, IngredientComponent<?, ?> ingredientComponent) {
        super(container, name, ingredientComponent);
    }

    @Override
    public ResourceLocation getTabSettingsName() {
        return GeneralConfig.syncItemStorageAndCraftingTabStates ? this.ingredientComponent.getName() : this.getName();
    }

    @Override
    protected void loadButtons(List<ITerminalButton<?, ?, ?>> buttons) {
        super.loadButtons(buttons);
        buttons.add(new TerminalButtonItemStackCraftingGridAutoRefill(this.container.getGuiState(), this));
        buttons.add(new TerminalButtonItemStackCraftingGridClear());
        buttons.add(new TerminalButtonItemStackCraftingGridBalance());
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public List<Component> getTooltip() {
        return Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integratedterminals.terminal_storage.crafting_name", (Object[])new Object[]{Component.translatable((String)this.ingredientComponent.getTranslationKey())})});
    }

    protected boolean isCraftingGridCenter() {
        return (Integer)TerminalStorageScreenSizeEvent.getWidthHeight().getLeft() < 374 || this.getRowColumnProvider().getRowsAndColumns().columns() < 17 || GeneralConfig.guiStorageForceCraftingGridCenter;
    }

    @Override
    public int getSlotVisibleRows() {
        if (this.isCraftingGridCenter()) {
            return Math.max(2, super.getSlotVisibleRows() - 4);
        }
        return super.getSlotVisibleRows();
    }

    @Override
    public int getPlayerInventoryOffsetX() {
        return super.getPlayerInventoryOffsetX() + (this.isCraftingGridCenter() ? 0 : 60);
    }

    @Override
    public int getPlayerInventoryOffsetY() {
        return super.getPlayerInventoryOffsetY() + (this.isCraftingGridCenter() ? 68 : 0);
    }

    @Override
    public boolean handleClick(AbstractContainerMenu container, int channel, int hoveringStorageSlot, int mouseButton, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot, boolean isQuickMove) {
        int craftingResultSlotIndex = TerminalStorageTabIngredientComponentItemStackCraftingCommon.getCraftingResultSlotIndex(container, this.getName());
        boolean shift = IModHelpers.get().getMinecraftClientHelpers().isShifted();
        if (hoveredContainerSlot == craftingResultSlotIndex && shift) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridShiftClickOutput(this.getName().toString(), channel, GeneralConfig.shiftClickCraftingResultLimit));
            return true;
        }
        if (!isQuickMove && hoveredContainerSlot > craftingResultSlotIndex && hoveredContainerSlot <= craftingResultSlotIndex + 9 && this.getActiveSlotId() < 0) {
            return false;
        }
        return super.handleClick(container, channel, hoveringStorageSlot, mouseButton, hasClickedOutside, hasClickedInStorage, hoveredContainerSlot, isQuickMove);
    }

    @Override
    public void onTabBackgroundRender(ContainerScreenTerminalStorage<?, ?> screen, GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        super.onTabBackgroundRender(screen, guiGraphics, f, mouseX, mouseY);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, screen.getGuiTexture(), screen.getGuiLeft() + screen.getGridXSize() / 2 - 9 * IModHelpers.get().getGuiHelpers().getSlotSize() / 2 + 51 - (this.isCraftingGridCenter() ? 0 : 107), screen.getGuiTop() + 52 + screen.getGridYSize(), 0.0f, 117.0f, 120, 68, 256, 256);
    }

    @Override
    public void onCommonSlotRender(AbstractContainerScreen gui, GuiGraphics guiGraphics, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, int slot, ITerminalStorageTabCommon tabCommon) {
        String name = this.ingredientComponent.getName().toString();
        ITerminalStorageTabClient tabClient = this.container.getTabClient(name);
        tabCommon = this.container.getTabCommon(name);
        tabClient.onCommonSlotRender(gui, guiGraphics, layer, partialTick, x, y, mouseX, mouseY, slot, tabCommon);
    }

    @Override
    public boolean isQuickMovePrevented(int slotIndex) {
        int craftingResultSlotIndex = TerminalStorageTabIngredientComponentItemStackCraftingCommon.getCraftingResultSlotIndex((AbstractContainerMenu)this.container, this.getName());
        return slotIndex == craftingResultSlotIndex;
    }
}

