/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;

public abstract class TerminalStorageIngredientCraftingOptionDataPacketAbstract<T, M, L, P extends TerminalStorageIngredientCraftingOptionDataPacketAbstract<T, M, L, P>>
extends PacketCodec<P> {
    @CodecField
    private String ingredientComponent;
    private ITerminalStorageLocation<L> location;
    private L locationInstance;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag craftingOption;
    @CodecField
    private int amount;
    @CodecField
    private CompoundTag craftingPlan;

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract(CustomPacketPayload.Type<P> type) {
        super(type);
    }

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract(CustomPacketPayload.Type<P> type, HolderLookup.Provider lookupProvider, CraftingOptionGuiData<T, M, L> craftingOptionData) {
        super(type);
        this.ingredientComponent = craftingOptionData.getComponent().getName().toString();
        this.location = craftingOptionData.getLocation();
        this.locationInstance = craftingOptionData.getLocationInstance();
        this.tabName = craftingOptionData.getTabName();
        this.channel = craftingOptionData.getChannel();
        this.craftingOption = craftingOptionData.getCraftingOption() != null ? IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o -> HandlerWrappedTerminalCraftingOption.serialize(o, craftingOptionData.getCraftingOption()), lookupProvider) : new CompoundTag();
        this.amount = craftingOptionData.getAmount();
        this.craftingPlan = craftingOptionData.getCraftingPlan() != null ? HandlerWrappedTerminalCraftingPlan.serialize(lookupProvider, craftingOptionData.getCraftingPlan()) : new CompoundTag();
    }

    public void encode(RegistryFriendlyByteBuf output) {
        super.encode(output);
        output.writeResourceLocation(this.location.getName());
        this.location.writeToPacketBuffer(output, this.locationInstance);
    }

    public void decode(RegistryFriendlyByteBuf input) {
        super.decode(input);
        this.location = TerminalStorageLocations.REGISTRY.getLocation(input.readResourceLocation());
        this.locationInstance = this.location.readFromPacketBuffer(input);
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingOption<T> getCraftingOption(HolderLookup.Provider lookupProvider, IngredientComponent<T, M> ingredientComponent) {
        try {
            return (HandlerWrappedTerminalCraftingOption)IModHelpers.get().getMinecraftHelpers().valueInputFromNbt(this.craftingOption, lookupProvider, i -> HandlerWrappedTerminalCraftingOption.deserialize(i, ingredientComponent));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getCraftingPlan(HolderLookup.Provider lookupProvider) {
        try {
            return HandlerWrappedTerminalCraftingPlan.deserialize(lookupProvider, this.craftingPlan);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)this.ingredientComponent));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + this.ingredientComponent);
        }
        return component;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getAmount() {
        return this.amount;
    }

    public CraftingOptionGuiData<T, M, L> getCraftingOptionData(HolderLookup.Provider lookupProvider) {
        IngredientComponent<T, M> ingredientComponent = this.getIngredientComponent();
        return new CraftingOptionGuiData<T, M, L>(ingredientComponent, this.tabName, this.channel, this.getCraftingOption(lookupProvider, ingredientComponent), this.amount, this.getCraftingPlan(lookupProvider), this.location, this.locationInstance);
    }
}

