/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.helper.IGuiHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerEnergy
implements IIngredientComponentTerminalStorageHandler<Long, Boolean> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerEnergy(IngredientComponent<Long, Boolean> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(GuiGraphics guiGraphics, Long instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        if (instance > 0L) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                int progressMaxScaled;
                int progressScaled;
                Lighting.setupForFlatItems();
                guiGraphics.blit(RenderType::guiTextured, Images.ICONS, x, y, 0.0f, 240.0f, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), 256, 256);
                if ((long)((int)maxQuantity) == maxQuantity) {
                    progressScaled = (int)instance.longValue();
                    progressMaxScaled = (int)maxQuantity;
                } else {
                    progressScaled = (int)(instance >> 16);
                    progressMaxScaled = (int)(maxQuantity >> 16);
                }
                IModHelpers.get().getGuiHelpers().renderProgressBar(guiGraphics, Images.ICONS, x, y, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), 16, 240, IGuiHelpers.ProgressDirection.UP, progressScaled, progressMaxScaled);
                GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
                renderItem.drawSlotText(Minecraft.getInstance().font, label != null ? label : IModHelpers.get().getGuiHelpers().quantityToScaledString(instance.longValue()), x, y);
                Lighting.setupFor3DItems();
            } else {
                IModHelpers.get().getGuiHelpers().renderTooltip(gui, guiGraphics.pose(), x, y, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), mouseX, mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(Component.translatable((String)"gui.integratedterminals.terminal_storage.tooltip.energy"));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(Long instance) {
        return IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.tooltip.energy.amount", new Object[]{String.format(Locale.ROOT, "%,d", instance)});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    @Override
    public Long getInstance(ItemStack itemStack) {
        return Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getEnergyStored).orElse(0).longValue();
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getMaxEnergyStored).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<Long, Boolean> storage, Long maxInstance, Player player) {
        return 0;
    }

    protected IIngredientComponentStorage<Long, Boolean> getEnergyStorage(IngredientComponent<Long, Boolean> component, IEnergyStorage energyStorage) {
        return component.getStorageWrapperHandler((BaseCapability)Capabilities.EnergyStorage.ITEM).wrapComponentStorage((Object)energyStorage);
    }

    @Override
    public Long insertIntoContainer(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Long maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.getSlot(containerSlot).getItem();
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            Long ret = 0L;
            try {
                ret = (Long)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (long)maxInstance, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.broadcastChanges();
            return ret;
        }).orElse(0L);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.getCarried();
        Optional.ofNullable((IEnergyStorage)playerStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.getSlot(containerSlot);
        if (slot.mayPickup(playerInventory.player)) {
            ItemStack toMoveStack = slot.getItem();
            Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
                IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.getCarried();
        return Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getEnergyStored).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.getCarried();
        Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = energyStorage.extractEnergy((int)quantity, false)) > 0; quantity -= (long)drained) {
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<Long> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return integer -> true;
    }

    @Override
    public Collection<IIngredientInstanceSorter<Long>> getInstanceSorters() {
        return Collections.emptyList();
    }
}

