/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.part;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanel;
import org.cyclops.integratedterminals.IntegratedTerminals;

public abstract class PartTypeTerminal<P extends PartTypeTerminal<P, S>, S extends IPartState<P>>
extends PartTypePanel<P, S> {
    public PartTypeTerminal(String name) {
        super(name);
    }

    public InteractionResult onPartActivated(S partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (this.isUpdate(partState) && !partState.isEnabled()) {
            player.displayClientMessage((Component)Component.translatable((String)"parttype.integrateddynamics.error.low_energy"), true);
            return InteractionResult.FAIL;
        }
        return super.onPartActivated(partState, pos, world, player, hand, heldItem, hit);
    }

    protected Block createBlock(BlockConfigCommon<?> blockConfig, BlockBehaviour.Properties properties) {
        return new IgnoredBlock(properties);
    }

    public ModBaseNeoForge<IntegratedTerminals> getMod() {
        return IntegratedTerminals._instance;
    }

    public boolean isUpdate(S state) {
        return this.getConsumptionRate((IPartState)state) > 0 && GeneralConfig.energyConsumptionMultiplier > 0;
    }
}

