/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;

public abstract class ContainerTerminalStorageCraftingPlanBase<L>
extends InventoryContainer {
    public static final String BUTTON_START = "start";
    private static final ExecutorService WORKER_POOL = Executors.newFixedThreadPool(GeneralConfig.craftingPlannerThreads);
    private final CraftingOptionGuiData craftingOptionGuiData;
    private final int craftingPlanNotifierId;
    private final int craftingPlanFlatNotifierId;
    private final Level world;
    private boolean calculatedCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;

    public ContainerTerminalStorageCraftingPlanBase(@Nullable MenuType<?> type, int id, Inventory playerInventory, CraftingOptionGuiData craftingOptionGuiData) {
        super(type, id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]));
        this.craftingOptionGuiData = craftingOptionGuiData;
        this.craftingPlanNotifierId = this.getNextValueId();
        this.craftingPlanFlatNotifierId = this.getNextValueId();
        this.world = playerInventory.player.level();
        this.putButtonAction(BUTTON_START, (buttonId, container) -> this.startCraftingJob());
    }

    public abstract Optional<INetwork> getNetwork();

    public Level getWorld() {
        return this.world;
    }

    public CraftingOptionGuiData getCraftingOptionGuiData() {
        return this.craftingOptionGuiData;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.level().isClientSide && !this.calculatedCraftingPlan) {
            this.calculatedCraftingPlan = true;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    public int getCraftingPlanFlatNotifierId() {
        return this.craftingPlanFlatNotifierId;
    }

    protected void updateCraftingPlan() {
        HandlerWrappedTerminalCraftingOption craftingOptionWrapper = this.craftingOptionGuiData.getCraftingOption();
        this.getNetwork().ifPresent(network -> {
            if (GeneralConfig.craftingPlannerEnableMultithreading) {
                WORKER_POOL.execute(() -> {
                    BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = true;
                    this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
                    BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = false;
                });
            } else {
                this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
            }
        });
    }

    protected void updateCraftingPlanJob(HandlerWrappedTerminalCraftingOption craftingOptionWrapper, INetwork network) {
        this.setCraftingPlan(craftingOptionWrapper.getHandler().calculateCraftingPlan(network, this.craftingOptionGuiData.getChannel(), craftingOptionWrapper.getCraftingOption(), this.craftingOptionGuiData.getAmount()));
    }

    protected void setCraftingPlan(ITerminalCraftingPlan craftingPlan) {
        this.craftingPlan = craftingPlan;
        if (!ContainerTerminalCraftingJobsPlan.isPlanTooLarge(this.craftingPlan)) {
            this.setValue(this.craftingPlanNotifierId, this.craftingOptionGuiData.getCraftingOption().getHandler().serializeCraftingPlan((HolderLookup.Provider)this.player.level().registryAccess(), this.craftingPlan));
        }
        this.setValue(this.craftingPlanFlatNotifierId, this.craftingOptionGuiData.getCraftingOption().getHandler().serializeCraftingPlanFlat((HolderLookup.Provider)this.player.level().registryAccess(), this.craftingPlan.flatten()));
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    private void startCraftingJob() {
        if (!this.getWorld().isClientSide() && this.craftingPlan != null) {
            this.getNetwork().ifPresent(network -> {
                try {
                    this.craftingOptionGuiData.getCraftingOption().getHandler().startCraftingJob((INetwork)network, this.craftingOptionGuiData.getChannel(), this.craftingPlan, (ServerPlayer)this.player);
                    this.craftingOptionGuiData.getLocation().openContainerFromServer(this.craftingOptionGuiData, this.getWorld(), (ServerPlayer)this.player);
                }
                catch (CraftingJobStartException e) {
                    this.craftingPlan.setError(e.getUnlocalizedError());
                    this.setCraftingPlan(this.craftingPlan);
                }
            });
        }
    }
}

