/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabRegistry;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandlerRegistry;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocationRegistry;
import org.cyclops.integratedterminals.block.BlockChorusGlassConfig;
import org.cyclops.integratedterminals.block.BlockMenrilGlassConfig;
import org.cyclops.integratedterminals.capability.ingredient.TerminalIngredientComponentCapabilities;
import org.cyclops.integratedterminals.component.DataComponentTerminalStorageInventoriesConfig;
import org.cyclops.integratedterminals.component.DataComponentTerminalStorageStateConfig;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabRegistry;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabs;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlerRegistry;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocationRegistry;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlanConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountItemConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountPartConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanItemConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanPartConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItemConfig;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePartConfig;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortableConfig;
import org.cyclops.integratedterminals.modcompat.integratedcrafting.IntegratedCraftingModCompat;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminals.proxy.ClientProxy;
import org.cyclops.integratedterminals.proxy.CommonProxy;

@Mod(value="integratedterminals")
public class IntegratedTerminals
extends ModBaseNeoForge<IntegratedTerminals> {
    public static IntegratedTerminals _instance;

    public IntegratedTerminals(IEventBus modEventBus) {
        super("integratedterminals", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(ITerminalStorageTabRegistry.class, (IRegistry)new TerminalStorageTabRegistry());
        this.getRegistryManager().addRegistry(ITerminalStorageTabIngredientCraftingHandlerRegistry.class, (IRegistry)TerminalStorageTabIngredientCraftingHandlerRegistry.getInstance());
        this.getRegistryManager().addRegistry(ITerminalStorageLocationRegistry.class, (IRegistry)new TerminalStorageLocationRegistry());
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::onSetup);
        TerminalStorageTabs.load();
        TerminalStorageTabIngredientCraftingHandlers.load();
        TerminalStorageLocations.load();
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        PartTypes.load();
        TerminalIngredientComponentCapabilities.load();
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat((IModCompat)new IntegratedCraftingModCompat());
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedterminals/info/terminals_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedterminals/info/terminals_tutorials.xml");
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_PART_TERMINAL_STORAGE));
    }

    public void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new BlockMenrilGlassConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new BlockChorusGlassConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemTerminalStoragePortableConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalCraftingJobsConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalCraftingJobsPlanConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStoragePartConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStorageCraftingOptionAmountPartConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStorageCraftingPlanPartConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStorageItemConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStorageCraftingOptionAmountItemConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalStorageCraftingPlanItemConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new DataComponentTerminalStorageInventoriesConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new DataComponentTerminalStorageStateConfig());
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public void onServerStarting(ServerStartingEvent event) {
        TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER = Executors.newFixedThreadPool(1);
    }

    public void onServerStopping(ServerStoppingEvent event) {
        TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER.shutdown();
        try {
            if (!TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER.awaitTermination(5L, TimeUnit.SECONDS)) {
                TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER.shutdownNow();
            Thread.currentThread().interrupt();
        }
        TerminalStorageTabIngredientComponentServer.PACKET_SERIALIZER = null;
    }

    public static void clog(String message) {
        IntegratedTerminals.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

