/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.ingredient;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;

public interface IIngredientComponentTerminalStorageHandler<T, M> {
    public IIngredientComponentTerminalStorageHandlerClient<T, M> getClient();

    public IngredientComponent<T, M> getComponent();

    public ItemStack getIcon();

    default public void addQuantityTooltip(List<Component> lines, T instance) {
        MutableComponent line = Component.translatable((String)"gui.integratedterminals.terminal_storage.tooltip.quantity", (Object[])new Object[]{this.formatQuantity(instance)}).withStyle(ChatFormatting.DARK_GRAY);
        if (lines.size() <= 1) {
            lines.add((Component)line);
        } else {
            lines.add(1, (Component)line);
        }
    }

    public String formatQuantity(T var1);

    public boolean isInstance(ItemStack var1);

    public T getInstance(ItemStack var1);

    public long getMaxQuantity(ItemStack var1);

    public int getInitialInstanceMovementQuantity();

    public int getIncrementalInstanceMovementQuantity();

    public int throwIntoWorld(IIngredientComponentStorage<T, M> var1, T var2, Player var3);

    default public void insertMaxIntoContainer(IIngredientComponentStorage<T, M> storage, AbstractContainerMenu container, int containerSlotStart, int containerSlotEnd, T instance) {
        IIngredientMatcher matcher = storage.getComponent().getMatcher();
        Object toAdd = instance;
        int slot = containerSlotStart;
        while (!matcher.isEmpty(toAdd) && slot < containerSlotEnd) {
            T moved;
            if (matcher.isEmpty(moved = this.insertIntoContainer(storage, container, slot++, toAdd, null, true))) continue;
            toAdd = matcher.withQuantity(toAdd, Math.max(0L, matcher.getQuantity(toAdd) - matcher.getQuantity(moved)));
        }
    }

    public T insertIntoContainer(IIngredientComponentStorage<T, M> var1, AbstractContainerMenu var2, int var3, T var4, @Nullable Player var5, boolean var6);

    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<T, M> var1, AbstractContainerMenu var2, Inventory var3, long var4);

    public void extractMaxFromContainerSlot(IIngredientComponentStorage<T, M> var1, AbstractContainerMenu var2, int var3, Inventory var4, int var5);

    public long getActivePlayerStackQuantity(Inventory var1, AbstractContainerMenu var2);

    public void drainActivePlayerStackQuantity(Inventory var1, AbstractContainerMenu var2, long var3);

    public Collection<IIngredientInstanceSorter<T>> getInstanceSorters();
}

