/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanFlatStatic;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> storageIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> storageIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.storageIngredients = storageIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getStorageIngredients() {
        return this.storageIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.unlocalizedLabelOverride == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    @Override
    public ITerminalCraftingPlanFlat<I> flatten() {
        IndexedEntries indexedEntries = new IndexedEntries();
        TerminalCraftingPlanStatic.groupDependenciesByPrototype(indexedEntries, this);
        TerminalCraftingPlanFlatStatic<I> planFlat = new TerminalCraftingPlanFlatStatic<I>(this.getId(), indexedEntries.getEntries().stream().sorted((e1, e2) -> {
            if (e1.getQuantityMissing() != e2.getQuantityMissing()) {
                return Math.toIntExact(e2.getQuantityMissing() - e1.getQuantityMissing());
            }
            if (e1.getQuantityCrafting() != e2.getQuantityCrafting()) {
                return Math.toIntExact(e2.getQuantityCrafting() - e1.getQuantityCrafting());
            }
            if (e1.getQuantityToCraft() != e2.getQuantityToCraft()) {
                return Math.toIntExact(e2.getQuantityToCraft() - e1.getQuantityToCraft());
            }
            if (e1.getQuantityInStorage() != e2.getQuantityInStorage()) {
                return Math.toIntExact(e2.getQuantityInStorage() - e1.getQuantityInStorage());
            }
            return 0;
        }).toList(), this.getOutputs(), this.getStatus(), this.getLabel(), this.getTickDuration(), this.getChannel(), this.getInitiatorName());
        if (this.getUnlocalizedLabelOverride() != null) {
            planFlat.setUnlocalizedLabelOverride(this.getUnlocalizedLabelOverride());
        }
        return planFlat;
    }

    protected static <I> void groupDependenciesByPrototype(IndexedEntries indexedEntries, ITerminalCraftingPlan<I> plan) {
        long quantity;
        TerminalCraftingPlanFlatStatic.Entry entry;
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            entry = indexedEntries.get(iPrototypedIngredient);
            quantity = IndexedEntries.getQuantity(iPrototypedIngredient);
            if (plan.getStatus() == TerminalCraftingJobStatus.ERROR || plan.getStatus() == TerminalCraftingJobStatus.INVALID || plan.getStatus() == TerminalCraftingJobStatus.INVALID_INPUTS) {
                if (plan.getDependencies().isEmpty()) {
                    entry.setQuantityMissing(entry.getQuantityMissing() + quantity);
                } else {
                    entry.setQuantityToCraft(entry.getQuantityToCraft() + quantity);
                }
            }
            if (plan.getStatus() == TerminalCraftingJobStatus.QUEUEING || plan.getStatus() == TerminalCraftingJobStatus.PENDING_DEPENDENCIES || plan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS || plan.getStatus() == TerminalCraftingJobStatus.CRAFTING || plan.getStatus() == TerminalCraftingJobStatus.UNSTARTED) {
                entry.setQuantityToCraft(entry.getQuantityToCraft() + quantity);
            }
            if (plan.getStatus() != TerminalCraftingJobStatus.CRAFTING && plan.getStatus() != TerminalCraftingJobStatus.FINISHED) continue;
            entry.setQuantityCrafting(entry.getQuantityCrafting() + quantity);
        }
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            entry = indexedEntries.get(iPrototypedIngredient);
            quantity = IndexedEntries.getQuantity(iPrototypedIngredient);
            entry.setQuantityInStorage(entry.getQuantityInStorage() + quantity);
        }
        for (List list : plan.getLastMissingIngredients()) {
            IPrototypedIngredient output = (IPrototypedIngredient)list.stream().findFirst().get();
            TerminalCraftingPlanFlatStatic.Entry entry2 = indexedEntries.get(output);
            long quantity2 = IndexedEntries.getQuantity(output);
            entry2.setQuantityMissing(entry2.getQuantityMissing() + quantity2 * plan.getCraftingQuantity());
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : plan.getDependencies()) {
            TerminalCraftingPlanStatic.groupDependenciesByPrototype(indexedEntries, iTerminalCraftingPlan);
        }
    }

    public static <I> void serialize(ValueOutput valueOutput, TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        handler.serializeCraftingJobId(valueOutput, plan.getId());
        ValueOutput.ValueOutputList dependencies = valueOutput.childrenList("dependencies");
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            TerminalCraftingPlanStatic.serialize(dependencies.addChild(), (TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler);
        }
        ValueOutput.ValueOutputList outputs = valueOutput.childrenList("outputs");
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            IPrototypedIngredient.serialize((ValueOutput)outputs.addChild(), (IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient));
        }
        valueOutput.putInt("status", plan.getStatus().ordinal());
        valueOutput.putLong("craftingQuantity", plan.getCraftingQuantity());
        ValueOutput.ValueOutputList valueOutputList = valueOutput.childrenList("storageIngredients");
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            IPrototypedIngredient.serialize((ValueOutput)valueOutputList.addChild(), (IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient));
        }
        ValueOutput.ValueOutputList valueOutputList2 = valueOutput.childrenList("lastMissingIngredients");
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            ValueOutput child = valueOutputList2.addChild();
            ValueOutput.ValueOutputList lastMissingIngredientTag = child.childrenList("v");
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                IPrototypedIngredient.serialize((ValueOutput)lastMissingIngredientTag.addChild(), (IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient));
            }
        }
        valueOutput.putInt("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            valueOutput.putString("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        valueOutput.putLong("tickDuration", plan.getTickDuration());
        valueOutput.putInt("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            valueOutput.putString("initiatorName", plan.getInitiatorName());
        }
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(ValueInput valueInput, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        I id = handler.deserializeCraftingJobId(valueInput);
        ArrayList dependencies = Lists.newArrayList();
        for (Object dependency : (ValueInput.ValueInputList)valueInput.childrenList("dependencies").orElseThrow()) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize((ValueInput)dependency, handler));
        }
        ArrayList outputs = Lists.newArrayList();
        for (ValueInput output : (ValueInput.ValueInputList)valueInput.childrenList("outputs").orElseThrow()) {
            outputs.add(IPrototypedIngredient.deserialize((ValueInput)output));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[(Integer)valueInput.getInt("status").orElseThrow()];
        long craftingQuantity = (Long)valueInput.getLong("craftingQuantity").orElseThrow();
        ArrayList storageIngredients = Lists.newArrayList();
        for (Object storageIngredient : (ValueInput.ValueInputList)valueInput.childrenList("storageIngredients").orElseThrow()) {
            storageIngredients.add(IPrototypedIngredient.deserialize((ValueInput)storageIngredient));
        }
        ArrayList lastMissingIngredients = Lists.newArrayList();
        for (ValueInput lastMissingIngredientValue : (ValueInput.ValueInputList)valueInput.childrenList("lastMissingIngredients").orElseThrow()) {
            ArrayList lastMissingIngredient = Lists.newArrayList();
            for (ValueInput base : (ValueInput.ValueInputList)lastMissingIngredientValue.childrenList("v").orElseThrow()) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((ValueInput)base));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        Label label = Label.values()[(Integer)valueInput.getInt("label").orElseThrow()];
        String unlocalizedLabelOverride = valueInput.getStringOr("unlocalizedLabelOverride", null);
        long tickDuration = (Long)valueInput.getLong("tickDuration").orElseThrow();
        int channel = (Integer)valueInput.getInt("channel").orElseThrow();
        String initiatorName = valueInput.getStringOr("initiatorName", null);
        TerminalCraftingPlanStatic<I> plan = new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, storageIngredients, lastMissingIngredients, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static enum Label {
        RUNNING("gui.integratedterminals.terminal_storage.craftingplan.label.running"),
        VALID("gui.integratedterminals.terminal_storage.craftingplan.label.valid"),
        INCOMPLETE("gui.integratedterminals.terminal_storage.craftingplan.label.failed.incomplete"),
        RECURSION("gui.integratedterminals.terminal_storage.craftingplan.label.failed.recursion"),
        ERROR("ERROR");

        private final String unlocalizedMessage;

        private Label(String unlocalizedMessage) {
            this.unlocalizedMessage = unlocalizedMessage;
        }

        public String getUnlocalizedMessage() {
            return this.unlocalizedMessage;
        }
    }

    public static class IndexedEntries {
        private final Map<IPrototypedIngredient<?, ?>, TerminalCraftingPlanFlatStatic.Entry> indexedEntries = Maps.newHashMap();

        public TerminalCraftingPlanFlatStatic.Entry get(IPrototypedIngredient<?, ?> prototypedIngredient) {
            IPrototypedIngredient<?, ?> prototype = this.getPrototype(prototypedIngredient);
            return this.indexedEntries.computeIfAbsent(prototype, k -> new TerminalCraftingPlanFlatStatic.Entry((IPrototypedIngredient<?, ?>)new PrototypedIngredient(prototypedIngredient.getComponent(), prototype.getPrototype(), prototypedIngredient.getCondition())));
        }

        protected <T, M> IPrototypedIngredient<T, M> getPrototype(IPrototypedIngredient<T, M> prototypedIngredient) {
            IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
            return new PrototypedIngredient(prototypedIngredient.getComponent(), matcher.withQuantity(prototypedIngredient.getPrototype(), 1L), matcher.getExactMatchNoQuantityCondition());
        }

        public static long getQuantity(IPrototypedIngredient<?, ?> prototypedIngredient) {
            IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
            return matcher.getQuantity(prototypedIngredient.getPrototype());
        }

        public Collection<TerminalCraftingPlanFlatStatic.Entry> getEntries() {
            return this.indexedEntries.values();
        }
    }
}

