/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerFluidStackClient;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackQuantitySorter;

public class IngredientComponentTerminalStorageHandlerFluidStack
implements IIngredientComponentTerminalStorageHandler<FluidStack, Integer> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IIngredientComponentTerminalStorageHandlerClient<FluidStack, Integer> getClient() {
        return new IngredientComponentTerminalStorageHandlerFluidStackClient(this);
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.WATER_BUCKET);
    }

    @Override
    public String formatQuantity(FluidStack instance) {
        return IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.tooltip.fluid.amount", new Object[]{String.format(Locale.ROOT, "%,d", IModHelpersNeoForge.get().getFluidHelpers().getAmount(instance))});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.FluidHandler.ITEM) != null;
    }

    @Override
    public FluidStack getInstance(ItemStack itemStack) {
        return Optional.ofNullable((IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0) : FluidStack.EMPTY).orElse(FluidStack.EMPTY);
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return Optional.ofNullable((IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getTankCapacity(0) : 0).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<FluidStack, Integer> storage, FluidStack maxInstance, Player player) {
        return 0;
    }

    @Override
    public FluidStack insertIntoContainer(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, int containerSlot, FluidStack maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.getSlot(containerSlot).getItem();
        return Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).map(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            FluidStack moved = FluidStack.EMPTY;
            try {
                moved = (FluidStack)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (Object)maxInstance, (Object)((Integer)this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition()), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.getSlot(containerSlot).set(fluidHandler.getContainer());
            container.broadcastChanges();
            return moved;
        }).orElse(FluidStack.EMPTY);
    }

    protected IIngredientComponentStorage<FluidStack, Integer> getFluidStorage(IngredientComponent<FluidStack, Integer> component, IFluidHandlerItem fluidHandler) {
        return component.getStorageWrapperHandler((BaseCapability)Capabilities.FluidHandler.ITEM).wrapComponentStorage((Object)fluidHandler);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.getCarried();
        Optional.ofNullable((IFluidHandlerItem)playerStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.setCarried(fluidHandler.getContainer());
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.getSlot(containerSlot);
        if (slot.mayPickup(playerInventory.player)) {
            ItemStack toMoveStack = slot.getItem();
            Optional.ofNullable((IFluidHandlerItem)toMoveStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(fluidHandler -> {
                IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
                container.getSlot(containerSlot).set(fluidHandler.getContainer());
                container.broadcastChanges();
            });
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.getCarried();
        return Optional.ofNullable((IFluidHandlerItem)toMoveStack.getCapability(Capabilities.FluidHandler.ITEM)).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0).getAmount() : 0).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.getCarried();
        Optional.ofNullable((IFluidHandlerItem)toMoveStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(fluidHandler -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = fluidHandler.drain((int)quantity, IFluidHandler.FluidAction.EXECUTE).getAmount()) > 0; quantity -= (long)drained) {
            }
            container.setCarried(fluidHandler.getContainer());
        });
    }

    @Override
    public Collection<IIngredientInstanceSorter<FluidStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new FluidStackNameSorter(), new FluidStackIdSorter(), new FluidStackQuantitySorter()});
    }
}

