/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButtonClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalRowColumnProvider;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonScaleGuiClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonScaleGui<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> {
    protected final TerminalStorageState state;
    protected final String buttonName;
    protected final ITerminalStorageTabClient<?> clientTab;
    protected GuiScale scale;

    public TerminalButtonScaleGui(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "gui_scale";
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public ITerminalButtonClient<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> getClient() {
        return new TerminalButtonScaleGuiClient(this);
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton("minecraft:itemstack", this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton("minecraft:itemstack", this.buttonName);
            this.scale = GuiScale.values()[(Integer)data.getInt("scale").orElseThrow()];
        } else {
            this.scale = GuiScale.SCALE_XY;
        }
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.scale";
    }

    @Override
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.scale.info").withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)this.scale.getLabel()));
    }

    public ITerminalRowColumnProvider getRowColumnProvider() {
        return this.scale.getRowColumnProvider();
    }

    public static enum GuiScale {
        SCALE_XY((IImage)Images.BUTTON_MIDDLE_SCALE_XY, "gui.integratedterminals.terminal_storage.scale.scalexy", () -> {
            Pair<Integer, Integer> widthHeight = TerminalStorageScreenSizeEvent.getWidthHeight();
            return new ITerminalRowColumnProvider.RowsAndColumns((int)Math.min(Math.max(1.0, Math.ceil(((Integer)widthHeight.getRight() - 146) / IModHelpers.get().getGuiHelpers().getSlotSize())), (double)GeneralConfig.guiStorageScaleMaxRows), (int)Math.min(Math.max(1.0, Math.ceil(((Integer)widthHeight.getLeft() - 56) / IModHelpers.get().getGuiHelpers().getSlotSize())), (double)GeneralConfig.guiStorageScaleMaxColumns));
        }),
        SCALE_Y((IImage)Images.BUTTON_MIDDLE_SCALE_Y, "gui.integratedterminals.terminal_storage.scale.scaley", () -> new ITerminalRowColumnProvider.RowsAndColumns((int)Math.min(Math.max(1.0, Math.ceil(((Integer)TerminalStorageScreenSizeEvent.getWidthHeight().getRight() - 146) / IModHelpers.get().getGuiHelpers().getSlotSize())), (double)GeneralConfig.guiStorageScaleMaxRows), GeneralConfig.guiStorageScaleHeightColumns)),
        SCALE_X((IImage)Images.BUTTON_MIDDLE_SCALE_X, "gui.integratedterminals.terminal_storage.scale.scalex", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleWidthRows, (int)Math.min(Math.max(1.0, Math.ceil(((Integer)TerminalStorageScreenSizeEvent.getWidthHeight().getLeft() - 56) / IModHelpers.get().getGuiHelpers().getSlotSize())), (double)GeneralConfig.guiStorageScaleMaxColumns))),
        SMALL((IImage)Images.BUTTON_MIDDLE_SCALE_SMALL, "gui.integratedterminals.terminal_storage.scale.small", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleSmallRows, GeneralConfig.guiStorageScaleSmallColumns)),
        MEDIUM((IImage)Images.BUTTON_MIDDLE_SCALE_MEDIUM, "gui.integratedterminals.terminal_storage.scale.medium", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleMediumRows, GeneralConfig.guiStorageScaleMediumColumns)),
        LARGE((IImage)Images.BUTTON_MIDDLE_SCALE_LARGE, "gui.integratedterminals.terminal_storage.scale.large", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleLargeRows, GeneralConfig.guiStorageScaleLargeColumns));

        @Nullable
        private final IImage image;
        private final String label;
        private final ITerminalRowColumnProvider rowColumnProvider;

        private GuiScale(IImage image, String label, ITerminalRowColumnProvider rowColumnProvider) {
            this.image = image;
            this.label = label;
            this.rowColumnProvider = rowColumnProvider;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }

        public ITerminalRowColumnProvider getRowColumnProvider() {
            return this.rowColumnProvider;
        }
    }
}

