/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButtonClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.ButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonSortClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonSort<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, ITerminalStorageTabCommon, ButtonSort> {
    protected final IIngredientInstanceSorter<T> instanceSorter;
    protected final TerminalStorageState state;
    protected final String buttonName;
    protected final ITerminalStorageTabClient<?> clientTab;
    protected Comparator<T> effectiveSorter;
    protected boolean active;
    protected boolean descending;

    public TerminalButtonSort(IIngredientInstanceSorter<T> instanceSorter, TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.instanceSorter = instanceSorter;
        this.state = state;
        this.buttonName = "sort_" + instanceSorter.getTranslationKey();
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public ITerminalButtonClient<TerminalStorageTabIngredientComponentClient<T, ?>, ITerminalStorageTabCommon, ButtonSort> getClient() {
        return new TerminalButtonSortClient(this);
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = (Boolean)data.getBoolean("active").orElseThrow();
            this.descending = (Boolean)data.getBoolean("descending").orElseThrow();
        } else {
            this.active = false;
            this.descending = true;
        }
        this.updateSorter();
    }

    protected void updateSorter() {
        this.effectiveSorter = this.active ? (this.descending ? this.instanceSorter.reversed() : this.instanceSorter) : null;
    }

    @Override
    public String getTranslationKey() {
        return this.instanceSorter.getTranslationKey();
    }

    @Override
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        this.instanceSorter.getTooltip(player, tooltipFlag, lines);
        if (this.active) {
            lines.add((Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.sort.order.label", (Object[])new Object[]{Component.translatable((String)(this.descending ? "gui.integratedterminals.terminal_storage.sort.order.descending" : "gui.integratedterminals.terminal_storage.sort.order.ascending"))}).withStyle(ChatFormatting.ITALIC));
        } else {
            lines.add((Component)Component.translatable((String)"general.cyclopscore.info.disabled").withStyle(ChatFormatting.ITALIC));
        }
    }

    @Nullable
    public Comparator<T> getEffectiveSorter() {
        return this.effectiveSorter;
    }
}

