/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.query;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.core.terminalstorage.query.IngredientQueryConjunctive;
import org.cyclops.integratedterminals.core.terminalstorage.query.IngredientQueryDisjunctive;
import org.cyclops.integratedterminals.core.terminalstorage.query.IngredientQueryLeaf;

public interface IIngredientQuery<T>
extends Predicate<T> {
    public static <T, M> IIngredientQuery<T> parse(IngredientComponent<T, M> ingredientComponent, String query) {
        if (query.contains(" ")) {
            String[] conjunctions = query.split(" ");
            return new IngredientQueryConjunctive(Arrays.stream(conjunctions).map(c -> IIngredientQuery.parse(ingredientComponent, c)).collect(Collectors.toList()));
        }
        if (query.contains("|")) {
            String[] disjunctions = query.split("\\|");
            return new IngredientQueryDisjunctive(Arrays.stream(disjunctions).map(c -> IIngredientQuery.parse(ingredientComponent, c)).collect(Collectors.toList()));
        }
        IIngredientComponentTerminalStorageHandler handler = (IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).orElseThrow(() -> new IllegalStateException("Could not find a terminal storage handler capability on an ingredient component"));
        return new IngredientQueryLeaf(query, handler);
    }
}

