/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class CancelCraftingJobPacket
extends PacketCodec<CancelCraftingJobPacket> {
    public static final CustomPacketPayload.Type<CancelCraftingJobPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"cancel_crafting_job"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CancelCraftingJobPacket> CODEC = CancelCraftingJobPacket.getCodec(CancelCraftingJobPacket::new);
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private int channel;
    @CodecField
    private String craftingPlanHandler;
    @CodecField
    private CompoundTag craftingJobId;

    public CancelCraftingJobPacket() {
        super(ID);
    }

    public CancelCraftingJobPacket(CraftingJobGuiData craftingPlanGuiData) {
        super(ID);
        this.pos = craftingPlanGuiData.getPos();
        this.side = craftingPlanGuiData.getSide();
        this.channel = craftingPlanGuiData.getChannel();
        this.craftingPlanHandler = craftingPlanGuiData.getHandler().getId().toString();
        this.craftingJobId = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o -> craftingPlanGuiData.getHandler().serializeCraftingJobId((ValueOutput)o, craftingPlanGuiData.getCraftingJob()));
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        NetworkHelpers.getNetwork((ILevelExtension)world, (BlockPos)this.pos, (Direction)this.side).ifPresent(network -> {
            ITerminalStorageTabIngredientCraftingHandler handler = this.getHandler();
            Object craftingJobId = IModHelpers.get().getMinecraftHelpers().valueInputFromNbt(this.craftingJobId, (HolderLookup.Provider)world.registryAccess(), handler::deserializeCraftingJobId);
            handler.cancelCraftingJob((INetwork)network, this.channel, craftingJobId);
        });
    }

    protected ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(ResourceLocation.parse((String)this.craftingPlanHandler));
    }
}

