/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientMaxQuantityPacket
extends PacketCodec<TerminalStorageIngredientMaxQuantityPacket> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientMaxQuantityPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_max_quantity"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientMaxQuantityPacket> CODEC = TerminalStorageIngredientMaxQuantityPacket.getCodec(TerminalStorageIngredientMaxQuantityPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private long maxQuantity;
    @CodecField
    private int channel;

    public TerminalStorageIngredientMaxQuantityPacket() {
        super(ID);
    }

    public TerminalStorageIngredientMaxQuantityPacket(String tabId, IngredientComponent<?, ?> ingredientComponent, long maxQuantity, int channel) {
        super(ID);
        this.tabId = tabId;
        this.ingredientName = ingredientComponent.getName().toString();
        this.maxQuantity = maxQuantity;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)this.ingredientName));
            if (ingredientComponent == null) {
                throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
            }
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            tab.setMaxQuantity(this.channel, this.maxQuantity);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.setMaxQuantity(this.channel, this.maxQuantity);
            }
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

