/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.purpurmc.purpurextras.PurpurExtras;

public class PurpurConfig {
    private final Logger logger;
    private FileConfiguration config;
    private final File configPath;

    protected PurpurConfig() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.reloadConfig();
        this.logger = plugin.getLogger();
        this.config = plugin.getConfig();
        this.configPath = new File(plugin.getDataFolder(), "config.yml");
    }

    protected void saveConfig() {
        try {
            this.config.save(this.configPath);
            this.config = PurpurExtras.getInstance().getConfig();
        }
        catch (IOException e) {
            this.logger.severe("Failed to save configuration file! - " + e.getLocalizedMessage());
        }
    }

    public boolean getBooleanIfExists(String path, boolean def) {
        if (this.config.isSet(path)) {
            Boolean setting = this.config.getBoolean(path, def);
            this.config.set(path, null);
            return setting;
        }
        return def;
    }

    public boolean getBoolean(String path, boolean def) {
        if (this.config.isSet(path)) {
            return this.config.getBoolean(path, def);
        }
        this.config.set(path, (Object)def);
        return def;
    }

    public String getString(String path, String def) {
        if (this.config.isSet(path)) {
            return this.config.getString(path, def);
        }
        this.config.set(path, (Object)def);
        return def;
    }

    public double getDouble(String path, double def) {
        if (this.config.isSet(path)) {
            return this.config.getDouble(path, def);
        }
        this.config.set(path, (Object)def);
        return def;
    }

    public int getInt(String path, int def) {
        if (this.config.isSet(path)) {
            return this.config.getInt(path, def);
        }
        this.config.set(path, (Object)def);
        return def;
    }

    public ConfigurationSection getConfigSection(String path, Map<String, Object> defKV) {
        if (this.config.isConfigurationSection(path)) {
            return this.config.getConfigurationSection(path);
        }
        return this.config.createSection(path, defKV);
    }

    public List<String> getList(String path, List<String> def) {
        if (this.config.isSet(path)) {
            return this.config.getStringList(path);
        }
        this.config.set(path, def);
        return def;
    }
}

