/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.MaterialSetTag;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class AnvilSplitsMinecartsAndBoatsModule
implements PurpurExtrasModule,
Listener {
    private final boolean splitBoats;
    private final boolean splitMinecarts = PurpurExtras.getPurpurConfig().getBoolean("settings.anvil-splits-minecarts", false);

    protected AnvilSplitsMinecartsAndBoatsModule() {
        this.splitBoats = PurpurExtras.getPurpurConfig().getBoolean("settings.anvil-splits-boats", false);
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.anvil-splits-minecarts", false) || PurpurExtras.getPurpurConfig().getBoolean("settings.anvil-splits-boats", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAnvilDrop(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof FallingBlock)) {
            return;
        }
        FallingBlock fallingBlock = (FallingBlock)entity2;
        if (!MaterialSetTag.ANVIL.isTagged((Keyed)fallingBlock.getBlockData().getMaterial())) {
            return;
        }
        Material itemMaterial = item.getItemStack().getType();
        Location location = event.getEntity().getLocation();
        if (this.splitBoats && MaterialSetTag.ITEMS_CHEST_BOATS.isTagged((Keyed)itemMaterial)) {
            String boatMaterialString = item.getItemStack().getType().toString().replace("_CHEST", "");
            Material boatMaterial = Material.matchMaterial((String)boatMaterialString);
            if (boatMaterial == null) {
                return;
            }
            location.getWorld().dropItemNaturally(location, new ItemStack(Material.CHEST));
            location.getWorld().dropItemNaturally(location, new ItemStack(boatMaterial));
            return;
        }
        if (!this.splitMinecarts) {
            return;
        }
        switch (itemMaterial) {
            case CHEST_MINECART: {
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.CHEST));
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.MINECART));
                break;
            }
            case FURNACE_MINECART: {
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.FURNACE));
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.MINECART));
                break;
            }
            case TNT_MINECART: {
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.TNT));
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.MINECART));
                break;
            }
            case HOPPER_MINECART: {
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.HOPPER));
                location.getWorld().dropItemNaturally(location, new ItemStack(Material.MINECART));
            }
        }
    }
}

