/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class CancelPetDamageFromOwnerModule
implements PurpurExtrasModule,
Listener {
    protected CancelPetDamageFromOwnerModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.gameplay-settings.cancel-damage-from-pet-owner", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPetDamage(EntityDamageByEntityEvent damageEvent) {
        Entity damager = damageEvent.getDamager();
        Entity entity = damageEvent.getEntity();
        if (!(entity instanceof Tameable)) {
            return;
        }
        Tameable pet = (Tameable)entity;
        if (!pet.isTamed()) {
            return;
        }
        AnimalTamer animalTamer = pet.getOwner();
        if (!(animalTamer instanceof OfflinePlayer)) {
            return;
        }
        OfflinePlayer owner = (OfflinePlayer)animalTamer;
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            ProjectileSource shooter = projectile.getShooter();
            if (!(shooter instanceof OfflinePlayer)) {
                return;
            }
            OfflinePlayer playerShooter = (OfflinePlayer)shooter;
            if (playerShooter != owner) {
                return;
            }
            damageEvent.setCancelled(true);
            if (projectile instanceof AbstractArrow && !projectile.getType().equals((Object)EntityType.TRIDENT)) {
                projectile.remove();
            }
            return;
        }
        if (!(damager instanceof OfflinePlayer)) {
            return;
        }
        OfflinePlayer damagingPlayer = (OfflinePlayer)damager;
        if (damagingPlayer.getUniqueId() != owner.getUniqueId()) {
            return;
        }
        damageEvent.setCancelled(true);
    }
}

