/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Boss;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class ColoredBossBarsModule
implements PurpurExtrasModule,
Listener {
    private final NamespacedKey dyeColor = PurpurExtras.key("dyedColor");

    protected ColoredBossBarsModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.dye-boss-bars", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBossBarDye(PlayerInteractEntityEvent event) {
        if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Boss)) {
            return;
        }
        Boss bossClicked = (Boss)entity;
        Player player = event.getPlayer();
        String materialName = player.getInventory().getItemInMainHand().getType().toString();
        if (!materialName.contains("_DYE")) {
            return;
        }
        int index = materialName.indexOf("_DYE");
        String bossBarColor = materialName.substring(0, index);
        try {
            BarColor.valueOf((String)bossBarColor);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        bossClicked.getBossBar().setColor(BarColor.valueOf((String)bossBarColor));
        PersistentDataContainer pdc = bossClicked.getPersistentDataContainer();
        pdc.set(this.dyeColor, PersistentDataType.STRING, (Object)bossBarColor);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBossBarDyeOnLoad(EntityAddToWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Boss)) {
            return;
        }
        Boss boss = (Boss)entity;
        PersistentDataContainer pdc = boss.getPersistentDataContainer();
        if (!pdc.has(this.dyeColor, PersistentDataType.STRING)) {
            return;
        }
        String color = (String)pdc.get(this.dyeColor, PersistentDataType.STRING);
        boss.getBossBar().setColor(BarColor.valueOf((String)color));
    }
}

