/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Squid;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class CreeperSquidsModule
implements PurpurExtrasModule,
Listener {
    private int maxSwell;
    private int maxDistance;
    private int explosionPower;
    private double velocity;

    @Override
    public void enable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PurpurExtras.getInstance());
        this.maxSwell = PurpurExtras.getPurpurConfig().getInt("settings.creeper-squid.fuse-ticks", 30);
        this.maxDistance = (int)Math.pow(PurpurExtras.getPurpurConfig().getInt("settings.creeper-squid.agro-distance", 7), 2.0);
        this.explosionPower = PurpurExtras.getPurpurConfig().getInt("settings.creeper-squid.explosion-radius", 3);
        this.velocity = PurpurExtras.getPurpurConfig().getDouble("settings.creeper-squid.velocity", 0.5);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.creeper-squid.enabled", false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onSquidSpawn(EntitySpawnEvent event) {
        if (event.getEntityType() != EntityType.SQUID) {
            return;
        }
        Squid squid = (Squid)event.getEntity();
        Bukkit.getMobGoals().removeAllGoals((Mob)squid, GoalType.TARGET);
        Bukkit.getMobGoals().addGoal((Mob)squid, 3, (Goal)new SquidGoal(squid));
    }

    private final class SquidGoal
    implements Goal<Squid> {
        private static final GoalKey<Squid> goalKey = GoalKey.of(Squid.class, (NamespacedKey)PurpurExtras.key("squidgoal"));
        private static final Predicate<Player> playerPredicate = player -> !player.hasPotionEffect(PotionEffectType.INVISIBILITY) && !player.isInvisible() && player.isValid() && (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE);
        private final Squid squid;
        private int currentSwell = 0;
        private int swellDir = -1;
        private Player currentTarget;

        public SquidGoal(Squid squid) {
            this.squid = squid;
        }

        public boolean shouldActivate() {
            if (!this.squid.isValid()) {
                return false;
            }
            if (this.currentTarget != null && this.currentTarget.getLocation().distanceSquared(this.squid.getLocation()) <= (double)CreeperSquidsModule.this.maxDistance) {
                return true;
            }
            this.currentTarget = this.getClosestPlayer();
            if (this.currentTarget == null) {
                this.swellDir = -1;
                if (this.currentSwell > 0) {
                    this.currentSwell += this.swellDir;
                }
                this.squid.setGlowing(false);
                return false;
            }
            return true;
        }

        public void stop() {
            this.squid.setTarget(null);
            this.squid.setVelocity(Vector.getRandom());
        }

        public void tick() {
            this.squid.setGlowing(!this.squid.isGlowing());
            if (this.currentTarget != null) {
                if (this.swellDir == -1) {
                    this.squid.getWorld().playSound(this.squid.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 1.0f, 0.5f);
                }
                this.swellDir = 1;
                this.squid.setVelocity(this.squid.getLocation().toVector().subtract(this.currentTarget.getLocation().toVector()).normalize().multiply(-1.0 * CreeperSquidsModule.this.velocity));
                this.squid.lookAt(this.currentTarget.getEyeLocation());
            }
            this.currentSwell += this.swellDir;
            if (this.currentSwell >= CreeperSquidsModule.this.maxSwell) {
                this.explode();
            }
        }

        @NotNull
        public GoalKey<Squid> getKey() {
            return goalKey;
        }

        @NotNull
        public EnumSet<GoalType> getTypes() {
            return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
        }

        private void explode() {
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)this.squid, 3.0f, true);
            event.callEvent();
            if (!event.isCancelled()) {
                this.squid.remove();
                this.squid.getWorld().createExplosion((Entity)this.squid, this.squid.getLocation(), (float)CreeperSquidsModule.this.explosionPower);
                Bukkit.getScheduler().runTaskLater((Plugin)PurpurExtras.getInstance(), () -> this.squid.getWorld().playSound(this.squid.getLocation(), Sound.ENTITY_CREEPER_DEATH, 1.0f, 0.5f), 1L);
            } else {
                this.currentSwell = 0;
            }
        }

        private Player getClosestPlayer() {
            Collection players = this.squid.getWorld().getNearbyEntitiesByType(Player.class, this.squid.getLocation(), (double)CreeperSquidsModule.this.maxDistance, playerPredicate);
            double playerDistance = -1.0;
            Player closestPlayer = null;
            for (Player player : players) {
                if (closestPlayer == null) {
                    closestPlayer = player;
                    playerDistance = player.getLocation().distanceSquared(this.squid.getLocation());
                    continue;
                }
                double dist = player.getLocation().distanceSquared(this.squid.getLocation());
                if (!(dist < playerDistance)) continue;
                closestPlayer = player;
                playerDistance = player.getLocation().distanceSquared(this.squid.getLocation());
            }
            return closestPlayer;
        }
    }
}

