/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.MaterialSetTag;
import com.destroystokyo.paper.MaterialTags;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;
import org.purpurmc.purpurextras.util.ItemStackUtil;

public class DispenserBlocksModule
implements PurpurExtrasModule,
Listener {
    private static final MaterialSetTag CAULDRON_BUCKETS = (MaterialSetTag)((MaterialSetTag)((MaterialSetTag)((MaterialSetTag)new MaterialSetTag(new NamespacedKey((Plugin)PurpurExtras.getInstance(), "cauldron_buckets"), new Material[0]).add((Keyed[])new Material[]{Material.BUCKET})).add((Keyed[])new Material[]{Material.WATER_BUCKET})).add((Keyed[])new Material[]{Material.LAVA_BUCKET})).add((Keyed[])new Material[]{Material.POWDER_SNOW_BUCKET});
    BlockData waterCauldron = Bukkit.createBlockData((Material)Material.WATER_CAULDRON, blockData -> {
        Levelled cauldron = (Levelled)blockData;
        cauldron.setLevel(3);
    });
    BlockData powderSnowCauldron = Bukkit.createBlockData((Material)Material.POWDER_SNOW_CAULDRON, blockData -> {
        Levelled cauldron = (Levelled)blockData;
        cauldron.setLevel(3);
    });
    BlockData lavaCauldron = Bukkit.createBlockData((Material)Material.LAVA_CAULDRON);
    private final boolean breakBlockPickaxe;
    private final boolean breakBlockShovel;
    private final boolean breakBlockHoe;
    private final boolean breakBlockAxe;
    private final boolean breakBlockShears;
    private final boolean shearPumpkin;
    private final boolean activateJukebox;
    private final boolean interactWithCauldron;

    protected DispenserBlocksModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        this.breakBlockPickaxe = config.getBoolean("settings.dispenser.break-blocks.pickaxe", false);
        this.breakBlockShovel = config.getBoolean("settings.dispenser.break-blocks.shovel", false);
        this.breakBlockHoe = config.getBoolean("settings.dispenser.break-blocks.hoe", false);
        this.breakBlockAxe = config.getBoolean("settings.dispenser.break-blocks.axe", false);
        this.breakBlockShears = config.getBoolean("settings.dispenser.break-blocks.shears", false);
        this.shearPumpkin = config.getBoolean("settings.dispenser.shears-shear-pumpkin", false);
        this.activateJukebox = config.getBoolean("settings.dispenser.puts-discs-in-jukebox", false);
        this.interactWithCauldron = config.getBoolean("settings.dispenser.interact-with-cauldron", false);
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return this.anyTrue(this.breakBlockAxe, this.breakBlockHoe, this.breakBlockPickaxe, this.breakBlockShovel, this.breakBlockShears, this.shearPumpkin, this.activateJukebox, this.interactWithCauldron);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPreDispense(BlockPreDispenseEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.DISPENSER)) {
            return;
        }
        Dispenser dispenser = (Dispenser)event.getBlock().getBlockData();
        Block block = event.getBlock().getRelative(dispenser.getFacing());
        org.bukkit.block.Dispenser blockDispenser = (org.bukkit.block.Dispenser)event.getBlock().getState(false);
        ItemStack item = event.getItemStack();
        if (this.breakBlockPickaxe && MaterialTags.PICKAXES.isTagged(item)) {
            event.setCancelled(true);
            if (this.tryBreakBlock(item, blockDispenser, block)) {
                return;
            }
        }
        if (this.breakBlockAxe && MaterialTags.AXES.isTagged(item)) {
            event.setCancelled(true);
            if (this.tryBreakBlock(item, blockDispenser, block)) {
                return;
            }
        }
        if (this.breakBlockShovel && MaterialTags.SHOVELS.isTagged(item)) {
            event.setCancelled(true);
            if (this.tryBreakBlock(item, blockDispenser, block)) {
                return;
            }
        }
        if (this.breakBlockHoe && MaterialTags.HOES.isTagged(item)) {
            event.setCancelled(true);
            if (this.tryBreakBlock(item, blockDispenser, block)) {
                return;
            }
        }
        if (this.breakBlockShears && Material.SHEARS.equals((Object)item.getType()) && this.tryBreakBlock(item, blockDispenser, block)) {
            event.setCancelled(true);
            return;
        }
        if (this.shearPumpkin && item.getType().equals((Object)Material.SHEARS) && block.getType().equals((Object)Material.PUMPKIN)) {
            Inventory inventory = blockDispenser.getInventory();
            this.damageItem(item, inventory);
            event.setCancelled(true);
            block.setType(Material.CARVED_PUMPKIN);
            return;
        }
        if (this.activateJukebox && MaterialTags.MUSIC_DISCS.isTagged(item) && block.getType().equals((Object)Material.JUKEBOX)) {
            event.setCancelled(true);
            Jukebox jukebox = (Jukebox)block.getState(false);
            jukebox.eject();
            ItemStack record = this.consumeItem(item);
            jukebox.setRecord(record);
            jukebox.update();
            return;
        }
        if (this.interactWithCauldron && Tag.CAULDRONS.isTagged((Keyed)block.getType()) && CAULDRON_BUCKETS.isTagged(item)) {
            Material dispensedItemType = item.getType();
            if (block.getType().equals((Object)Material.CAULDRON)) {
                switch (dispensedItemType) {
                    case BUCKET: {
                        return;
                    }
                    case LAVA_BUCKET: {
                        this.emptyCauldronHandler(block, this.lavaCauldron, item, blockDispenser.getLocation(), Sound.ITEM_BUCKET_EMPTY_LAVA);
                        event.setCancelled(true);
                        return;
                    }
                    case WATER_BUCKET: {
                        this.emptyCauldronHandler(block, this.waterCauldron, item, blockDispenser.getLocation(), Sound.ITEM_BUCKET_EMPTY);
                        event.setCancelled(true);
                        return;
                    }
                    case POWDER_SNOW_BUCKET: {
                        this.emptyCauldronHandler(block, this.powderSnowCauldron, item, blockDispenser.getLocation(), Sound.ITEM_BUCKET_EMPTY_POWDER_SNOW);
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            if (!dispensedItemType.equals((Object)Material.BUCKET)) {
                return;
            }
            switch (block.getType()) {
                case LAVA_CAULDRON: {
                    this.fullCauldronHandler(block, item, blockDispenser, Material.LAVA_BUCKET, Sound.ITEM_BUCKET_FILL_LAVA);
                    event.setCancelled(true);
                    break;
                }
                case WATER_CAULDRON: {
                    Levelled cauldronLevel = (Levelled)block.getBlockData();
                    if (cauldronLevel.getLevel() < 3) {
                        return;
                    }
                    this.fullCauldronHandler(block, item, blockDispenser, Material.WATER_BUCKET, Sound.ITEM_BUCKET_FILL);
                    event.setCancelled(true);
                    break;
                }
                case POWDER_SNOW_CAULDRON: {
                    Levelled cauldronLevel = (Levelled)block.getBlockData();
                    if (cauldronLevel.getLevel() < 3) {
                        return;
                    }
                    this.fullCauldronHandler(block, item, blockDispenser, Material.POWDER_SNOW_BUCKET, Sound.ITEM_BUCKET_FILL_POWDER_SNOW);
                    event.setCancelled(true);
                }
            }
        }
    }

    private void damageItem(ItemStack itemStack, Inventory inventory) {
        int slot = inventory.first(itemStack);
        if (slot == -1) {
            return;
        }
        ItemStack item = inventory.getItem(slot);
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        ItemStackUtil.damage(item, 1, false);
    }

    private ItemStack consumeItem(ItemStack itemStack) {
        ItemStack consumed = itemStack.clone();
        consumed.setAmount(1);
        itemStack.setAmount(itemStack.getAmount() - 1);
        return consumed;
    }

    private boolean tryBreakBlock(ItemStack itemStack, org.bukkit.block.Dispenser dispenser, Block block) {
        if (block.getDestroySpeed(itemStack, false) <= 1.0f) {
            return false;
        }
        Inventory inventory = dispenser.getInventory();
        this.damageItem(itemStack, inventory);
        return block.breakNaturally(itemStack, true);
    }

    private boolean anyTrue(boolean ... booleans) {
        for (boolean b : booleans) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    private void emptyCauldronHandler(Block cauldron, BlockData cauldronType, ItemStack dispensingItem, Location dispLocation, Sound uniqueSound) {
        cauldron.setBlockData(cauldronType);
        dispensingItem.setType(Material.BUCKET);
        dispLocation.getWorld().playSound(dispLocation, Sound.BLOCK_DISPENSER_DISPENSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        dispLocation.getWorld().playSound(dispLocation, uniqueSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void fullCauldronHandler(Block cauldron, ItemStack items, org.bukkit.block.Dispenser dispenserBlock, Material newItem, Sound uniqueSound) {
        cauldron.setType(Material.CAULDRON);
        Inventory inv = dispenserBlock.getInventory();
        ItemStack newItemDrop = new ItemStack(newItem);
        if (items.getAmount() > 1) {
            items.setAmount(items.getAmount() - 1);
            HashMap map = inv.addItem(new ItemStack[]{newItemDrop});
            if (!map.isEmpty()) {
                cauldron.getWorld().dropItem(cauldron.getLocation(), newItemDrop);
            }
        } else {
            items.setType(newItem);
        }
        dispenserBlock.getWorld().playSound(dispenserBlock.getLocation(), Sound.BLOCK_DISPENSER_DISPENSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        dispenserBlock.getWorld().playSound(dispenserBlock.getLocation(), uniqueSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

