/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import io.papermc.paper.event.entity.EntityMoveEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class ForceNametaggedForRidingModule
implements PurpurExtrasModule,
Listener {
    protected ForceNametaggedForRidingModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.rideables.mob-needs-to-be-nametagged-to-ride", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMount(EntityMountEvent event) {
        Steerable steerable;
        Entity entity = event.getMount();
        if (entity instanceof Steerable && (steerable = (Steerable)entity).hasSaddle()) {
            return;
        }
        if (entity instanceof Vehicle && !(entity instanceof Steerable)) {
            return;
        }
        if (entity.getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        if (entity.customName() != null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMountMove(EntityMoveEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Vehicle)) {
            return;
        }
        Vehicle vehicle = (Vehicle)livingEntity;
        if (vehicle.getPassengers().isEmpty()) {
            return;
        }
        Entity passenger = (Entity)vehicle.getPassengers().get(0);
        if (!(passenger instanceof Player)) {
            return;
        }
        Player player = (Player)passenger;
        if (vehicle.customName() != null && player.hasPermission("allow.ride." + vehicle.getType().getKey().getKey())) {
            return;
        }
        event.setCancelled(true);
    }
}

