/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpur.event.inventory.GrindstoneTakeResultEvent;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class GrindstoneEnchantsBooksModule
implements PurpurExtrasModule,
Listener {
    private final ItemStack BOOK = new ItemStack(Material.BOOK);

    protected GrindstoneEnchantsBooksModule() {
    }

    @Override
    public void enable() {
        try {
            Class.forName("org.purpurmc.purpur.event.inventory.GrindstoneTakeResultEvent");
        }
        catch (ClassNotFoundException e) {
            PurpurExtras.getInstance().getLogger().warning(this.getClass().getSimpleName() + " module requires you to run Purpur as your server software.");
            return;
        }
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.grindstone.gives-enchants-back", false);
    }

    @EventHandler
    public void on(GrindstoneTakeResultEvent event) {
        GrindstoneInventory grindstoneInventory = event.getInventory();
        ItemStack lowerItem = grindstoneInventory.getLowerItem();
        if (lowerItem != null && !lowerItem.getType().isAir()) {
            return;
        }
        ItemStack upperItem = grindstoneInventory.getUpperItem();
        if (upperItem == null || upperItem.getType().isAir()) {
            return;
        }
        if (upperItem.getType() == Material.ENCHANTED_BOOK) {
            Map stored;
            boolean hasNonCursed;
            if (upperItem.hasItemMeta() && (hasNonCursed = (stored = ((EnchantmentStorageMeta)upperItem.getItemMeta()).getStoredEnchants()).keySet().stream().anyMatch(e -> !e.isCursed()))) {
                event.setExperienceAmount(0);
            }
            return;
        }
        if (!upperItem.hasEnchants()) {
            return;
        }
        Map enchants = upperItem.getEnchants();
        if (enchants.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        Location location = player.getLocation();
        World world = location.getWorld();
        PlayerInventory playerInventory = player.getInventory();
        boolean gaveAny = false;
        for (Map.Entry entry : enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (enchant.isCursed()) continue;
            if (player.getGameMode() != GameMode.CREATIVE && (!playerInventory.containsAtLeast(this.BOOK, 1) || !playerInventory.removeItem(new ItemStack[]{this.BOOK}).isEmpty())) break;
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
            meta.addStoredEnchant(enchant, level, true);
            book.setItemMeta((ItemMeta)meta);
            playerInventory.addItem(new ItemStack[]{book}).forEach((index, stack) -> {
                Item drop = world.dropItemNaturally(location, stack);
                drop.setPickupDelay(0);
            });
            gaveAny = true;
        }
        if (gaveAny) {
            event.setExperienceAmount(0);
        }
    }
}

