/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.event.entity.EntityZapEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.entiddy.Entiddy;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;
import org.purpurmc.purpurextras.util.EntityStatePreserverUtil;

public class LightningTransformsMobsModule
implements PurpurExtrasModule,
Listener {
    private final HashMap<String, Object> entities = new HashMap();
    private final boolean preserveMobStateOnLightningTransformation;

    protected LightningTransformsMobsModule() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("villager", "witch");
        defaults.put("pig", "zombified_piglin");
        ConfigurationSection section = PurpurExtras.getPurpurConfig().getConfigSection("settings.lightning-transforms-entities.entities", defaults);
        this.preserveMobStateOnLightningTransformation = PurpurExtras.getPurpurConfig().getBoolean("settings.lightning-transforms-entities.preserve-entity-state", false);
        HashMap<String, String> lightningTransformEntities = new HashMap<String, String>();
        for (String string : section.getKeys(false)) {
            String value = section.getString(string);
            lightningTransformEntities.put(string, value);
        }
        for (Map.Entry entry : lightningTransformEntities.entrySet()) {
            this.getEntityTypeOrSpecial((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        if (this.entities.isEmpty()) {
            return false;
        }
        return PurpurExtras.getPurpurConfig().getBoolean("settings.lightning-transforms-entities.enabled", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLightningStrike(EntityDamageByEntityEvent event) {
        if (!event.getDamager().getType().equals((Object)EntityType.LIGHTNING_BOLT)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.getEntitySpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.LIGHTNING)) {
            event.setCancelled(true);
            return;
        }
        Location location = entity.getLocation();
        Entiddy specialEntity = Entiddy.fromEntity(livingEntity);
        Object targetEntity = null;
        String entityKey = null;
        if (specialEntity != null) {
            entityKey = specialEntity.entiddy().toString().toLowerCase(Locale.ROOT);
            targetEntity = this.entities.get(entityKey);
        } else {
            entityKey = entity.getType().getKey().getKey();
            targetEntity = this.entities.get(entityKey);
        }
        if (targetEntity == null) {
            return;
        }
        event.setCancelled(true);
        Entity spawnedEntity = this.spawnEntity(targetEntity, location);
        if (this.preserveMobStateOnLightningTransformation && spawnedEntity instanceof LivingEntity) {
            LivingEntity newEntity = (LivingEntity)spawnedEntity;
            EntityStatePreserverUtil.preserveEntityState(livingEntity, newEntity);
        }
        entity.remove();
    }

    private Entity spawnEntity(Object entity, Location location) {
        Entity spawnedEntity = null;
        if (entity instanceof EntityType) {
            EntityType entityType = (EntityType)entity;
            spawnedEntity = location.getWorld().spawnEntity(location, entityType, CreatureSpawnEvent.SpawnReason.LIGHTNING);
        } else if (entity instanceof Entiddy) {
            Entiddy entiddy = (Entiddy)((Object)entity);
            spawnedEntity = entiddy.entiddy().spawn(location, CreatureSpawnEvent.SpawnReason.LIGHTNING);
        }
        return spawnedEntity;
    }

    private void getEntityTypeOrSpecial(String key, String value) {
        String sourceKey = null;
        Entiddy goal = null;
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.isSpawnable()) continue;
            String entityKey = entityType.getKey().getKey();
            if (entityKey.equals(key.toLowerCase(Locale.ROOT))) {
                sourceKey = key;
            }
            if (!entityKey.equals(value.toLowerCase(Locale.ROOT))) continue;
            goal = entityType;
        }
        if (sourceKey == null) {
            try {
                Entiddy.valueOf(key.toUpperCase(Locale.ROOT));
                sourceKey = key;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (goal == null) {
            try {
                goal = Entiddy.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.entities.put(sourceKey, (Object)goal);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLightningStrike(EntityZapEvent event) {
        if (event.getBolt().isEffect()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.getEntitySpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.LIGHTNING)) {
            event.setCancelled(true);
            return;
        }
        Location location = entity.getLocation();
        Entiddy specialEntity = Entiddy.fromEntity(livingEntity);
        if (specialEntity != null) {
            event.setCancelled(true);
            String specialEntityKey = specialEntity.entiddy().toString().toLowerCase(Locale.ROOT);
            Object targetEntity = this.entities.get(specialEntityKey);
            Entity spawnedEntity = this.spawnEntity(targetEntity, location);
            if (this.preserveMobStateOnLightningTransformation && spawnedEntity instanceof LivingEntity) {
                LivingEntity newEntity = (LivingEntity)spawnedEntity;
                EntityStatePreserverUtil.preserveEntityState(livingEntity, newEntity);
            }
            entity.remove();
            return;
        }
        Object targetEntity = this.entities.get(entity.getType().getKey().getKey());
        if (targetEntity == null) {
            livingEntity.damage(5.0, (Entity)event.getBolt());
            event.setCancelled(true);
            return;
        }
        Entity spawnedEntity = this.spawnEntity(targetEntity, location);
        if (this.preserveMobStateOnLightningTransformation && spawnedEntity instanceof LivingEntity) {
            LivingEntity newEntity = (LivingEntity)spawnedEntity;
            EntityStatePreserverUtil.preserveEntityState(livingEntity, newEntity);
        }
        entity.remove();
        event.setCancelled(true);
    }
}

