/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import com.destroystokyo.paper.MaterialSetTag;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.block.banner.Pattern;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.LoomInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class LoomMaxLayersModule
implements PurpurExtrasModule,
Listener {
    private final HashMap<Player, List<Pattern>> playerBannerData = new HashMap();
    private int maxLayers = PurpurExtras.getPurpurConfig().getInt("settings.loom.max-layers", 6);

    protected LoomMaxLayersModule() {
        if (this.maxLayers <= 0) {
            this.maxLayers = 6;
        }
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return this.maxLayers != 6;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if (!(event.getInventory() instanceof LoomInventory)) {
            return;
        }
        if (currentItem != null && MaterialSetTag.BANNERS.isTagged((Keyed)currentItem.getType())) {
            if (this.doesNewLayerExceedMaxLayers(currentItem)) {
                return;
            }
            switch (event.getSlotType()) {
                case CRAFTING: {
                    if (this.isPlaceAction(event.getAction())) {
                        this.saveBannerLayers(player, currentItem);
                        break;
                    }
                    this.setOldPatternsToBanner(player, currentItem);
                    break;
                }
                case CONTAINER: 
                case QUICKBAR: {
                    if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) break;
                    this.saveBannerLayers(player, currentItem);
                    break;
                }
                case RESULT: {
                    this.setNewPatternsToBanner(player, currentItem);
                }
            }
        } else if (cursorItem != null && MaterialSetTag.BANNERS.isTagged((Keyed)cursorItem.getType())) {
            if (this.doesNewLayerExceedMaxLayers(cursorItem)) {
                return;
            }
            if (event.getSlotType().equals((Object)InventoryType.SlotType.CRAFTING) && this.isPlaceAction(event.getAction())) {
                this.saveBannerLayers(player, cursorItem);
            }
        }
    }

    private boolean isPlaceAction(InventoryAction action) {
        return action == InventoryAction.PLACE_SOME || action == InventoryAction.PLACE_ALL || action == InventoryAction.PLACE_ONE;
    }

    private void saveBannerLayers(Player player, ItemStack banner) {
        BannerMeta meta = (BannerMeta)banner.getItemMeta();
        List patterns = meta.getPatterns();
        if (patterns.size() <= 5) {
            return;
        }
        this.playerBannerData.remove(player);
        this.playerBannerData.put(player, patterns);
        this.removeExtraLayersFromBanner(banner);
    }

    private void removeExtraLayersFromBanner(ItemStack banner) {
        BannerMeta meta = (BannerMeta)banner.getItemMeta();
        List patterns = meta.getPatterns();
        while (patterns.size() > 5) {
            patterns.remove(0);
        }
        meta.setPatterns(patterns);
        banner.setItemMeta((ItemMeta)meta);
    }

    private void setOldPatternsToBanner(Player player, ItemStack banner) {
        if (!this.playerBannerData.containsKey(player)) {
            return;
        }
        List<Pattern> oldPatterns = this.playerBannerData.get(player);
        BannerMeta meta = (BannerMeta)banner.getItemMeta();
        meta.setPatterns(oldPatterns);
        banner.setItemMeta((ItemMeta)meta);
        this.playerBannerData.remove(player);
    }

    private void setNewPatternsToBanner(Player player, ItemStack banner) {
        if (!this.playerBannerData.containsKey(player)) {
            return;
        }
        List<Pattern> oldPatterns = this.playerBannerData.get(player);
        BannerMeta meta = (BannerMeta)banner.getItemMeta();
        List newPatterns = meta.getPatterns();
        oldPatterns.add((Pattern)newPatterns.get(newPatterns.size() - 1));
        meta.setPatterns(oldPatterns);
        banner.setItemMeta((ItemMeta)meta);
        this.playerBannerData.remove(player);
    }

    private boolean doesNewLayerExceedMaxLayers(ItemStack banner) {
        BannerMeta meta = (BannerMeta)banner.getItemMeta();
        List patterns = meta.getPatterns();
        return patterns.size() == this.maxLayers;
    }
}

