/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.block.BlockState;
import org.bukkit.block.DecoratedPot;
import org.bukkit.block.Vault;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.loot.Lootable;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;
import org.purpurmc.purpurextras.util.MessageType;

public class LootBlocksProtectionModule
implements PurpurExtrasModule,
Listener {
    private final Component message;
    private MessageType messageType;
    private final boolean allowBreakingInSneak;
    private final boolean blocksImmuneToExplosions;
    private final Permission lootBlockBypass = new Permission("purpurextras.lootblockprotectionbypass", "Players with this permission will be able to break blocks with loot tables that can regenerate loot", PermissionDefault.OP);

    protected LootBlocksProtectionModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        String defaultMessage = "<red>Prevented you from breaking this block because it can regenerate loot. Sneak to break it anyway.";
        this.message = MiniMessage.miniMessage().deserialize((Object)config.getString("settings.protect-blocks-with-loot.message", defaultMessage));
        this.allowBreakingInSneak = config.getBoolean("settings.protect-blocks-with-loot.allow-breaking-in-sneak", true);
        this.blocksImmuneToExplosions = config.getBoolean("settings.protect-blocks-with-loot.immune-to-explosions", false);
        try {
            this.messageType = MessageType.valueOf(config.getString("settings.protect-blocks-with-loot.message-type", "CHAT").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.messageType = MessageType.CHAT;
        }
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.lootBlockBypass);
        return PurpurExtras.getPurpurConfig().getBoolean("settings.protect-blocks-with-loot.enabled", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDestroyBlockWithLoot(BlockBreakEvent event) {
        if (this.isProtected(event.getBlock().getState(true))) {
            this.handleLootBlockDestruction(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplodingBlockWithLoot(EntityExplodeEvent event) {
        if (!this.blocksImmuneToExplosions) {
            return;
        }
        event.blockList().removeIf(block -> this.isProtected(block.getState(true)));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplodingBlockWithLoot(BlockExplodeEvent event) {
        if (!this.blocksImmuneToExplosions) {
            return;
        }
        event.blockList().removeIf(block -> this.isProtected(block.getState(true)));
    }

    private void handleLootBlockDestruction(BlockBreakEvent event) {
        if (event.getPlayer().hasPermission(this.lootBlockBypass)) {
            return;
        }
        if (this.allowBreakingInSneak && event.getPlayer().isSneaking()) {
            return;
        }
        event.setCancelled(true);
        switch (this.messageType) {
            case CHAT: {
                event.getPlayer().sendMessage(this.message);
                break;
            }
            case ACTION_BAR: {
                event.getPlayer().sendActionBar(this.message);
            }
        }
    }

    private boolean isProtected(BlockState blockState) {
        if (blockState instanceof DecoratedPot) {
            return false;
        }
        if (blockState instanceof Lootable) {
            Lootable lootable = (Lootable)blockState;
            return lootable.hasLootTable();
        }
        return blockState instanceof Vault;
    }
}

