/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class MobNoTargetModule
implements PurpurExtrasModule,
Listener {
    protected MobNoTargetModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerTargetPermissions(PurpurExtras.getInstance());
        return PurpurExtras.getPurpurConfig().getBoolean("settings.use-notarget-permissions", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMobTarget(EntityTargetEvent event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.hasPermission("target.bypass." + event.getEntityType().getKey().getKey())) {
            return;
        }
        event.setCancelled(true);
    }

    private void registerTargetPermissions(PurpurExtras plugin) {
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.isAlive()) continue;
            String name = entityType.getKey().getKey();
            String permissionName = "target.bypass." + name;
            String description = "Prevents a user from being targeted by " + name + "s ";
            Permission perm = new Permission(permissionName, description, PermissionDefault.FALSE);
            this.registerPermissions(perm);
        }
    }
}

