/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class NetherBuildHeightModule
implements PurpurExtrasModule,
Listener {
    private final int configBuildHeight;
    private final String noPermissionMessageContent;
    private final Permission netherBuildHeightBypassPermission = new Permission("purpurextras.netherbuildheightbypass", "Allows player to bypass the configured max nether build height", PermissionDefault.OP);

    protected NetherBuildHeightModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        this.configBuildHeight = config.getInt("settings.block-building-above-nether.height-limit", 128);
        this.noPermissionMessageContent = config.getString("settings.block-building-above-nether.no-permission-message", "<red>Max build height in this world is: <gold><height>");
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.netherBuildHeightBypassPermission);
        return PurpurExtras.getPurpurConfig().getBoolean("settings.block-building-above-nether.enabled", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNetherRoofBuild(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!block.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        if (block.getLocation().getBlockY() < this.configBuildHeight) {
            return;
        }
        if (player.hasPermission(this.netherBuildHeightBypassPermission)) {
            return;
        }
        if (!"".equals(this.noPermissionMessageContent)) {
            player.sendActionBar(PurpurExtras.getInstance().miniMessage.deserialize(this.noPermissionMessageContent, (TagResolver)Placeholder.unparsed((String)"height", (String)String.valueOf(this.configBuildHeight))));
        }
        event.setCancelled(true);
    }
}

