/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class OpenIronDoorsWithHandModule
implements PurpurExtrasModule,
Listener {
    private final boolean doors;
    private final boolean trapdoors;
    private final Permission openIronDoorsPermission = new Permission("purpurextras.openirondoors", "Allows for opening iron doors with a hand", PermissionDefault.TRUE);
    private final Permission openIronTrapdoorsPermission = new Permission("purpurextras.openirontrapdoors", "Allows for opening iron trapdoors with a hand", PermissionDefault.TRUE);

    protected OpenIronDoorsWithHandModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        this.doors = config.getBoolean("settings.gameplay-settings.open-iron-doors-with-hand", false);
        this.trapdoors = config.getBoolean("settings.gameplay-settings.open-iron-trapdoors-with-hand", false);
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.openIronDoorsPermission, this.openIronTrapdoorsPermission);
        return this.doors || this.trapdoors;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onIronDoorOpen(PlayerInteractEvent event) {
        if (!EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            return;
        }
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        World world = block.getWorld();
        switch (block.getType()) {
            case IRON_DOOR: {
                if (!this.doors) {
                    return;
                }
                if (!event.getPlayer().hasPermission(this.openIronDoorsPermission)) {
                    return;
                }
                event.setCancelled(true);
                if (this.open(block, event.getPlayer())) {
                    world.playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    break;
                }
                world.playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case IRON_TRAPDOOR: {
                if (!this.trapdoors) {
                    return;
                }
                if (!event.getPlayer().hasPermission(this.openIronTrapdoorsPermission)) {
                    return;
                }
                event.setCancelled(true);
                if (this.open(block, event.getPlayer())) {
                    world.playSound(block.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    break;
                }
                world.playSound(block.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private boolean open(Block block, Player player) {
        Openable openable;
        boolean isOpen = (openable = (Openable)block.getBlockData()).isOpen();
        openable.setOpen(!isOpen);
        block.setBlockData((BlockData)openable);
        player.swingMainHand();
        return !isOpen;
    }
}

