/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import java.util.HashMap;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Raider;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class RaidTotemDropsModule
implements PurpurExtrasModule,
Listener {
    private final SplittableRandom random;
    private final double dropChance;
    private final Map<UUID, Raider> raiders = new HashMap<UUID, Raider>();
    private final ItemStack totem = new ItemStack(Material.TOTEM_OF_UNDYING);

    protected RaidTotemDropsModule() {
        this.dropChance = PurpurExtras.getPurpurConfig().getDouble("settings.raid-totem-drops.chance", 0.0);
        this.random = new SplittableRandom();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onRaidSpawn(RaidSpawnWaveEvent event) {
        event.getRaiders().forEach(r -> this.raiders.put(r.getUniqueId(), (Raider)r));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onRaidDeath(EntityDeathEvent event) {
        if (this.raiders.get(event.getEntity().getUniqueId()) == null) {
            return;
        }
        this.raiders.remove(event.getEntity().getUniqueId());
        if (event.getEntityType() != EntityType.EVOKER) {
            return;
        }
        boolean totemShouldDrop = (double)this.random.nextFloat() < this.dropChance;
        event.getDrops().stream().filter(i -> i.getType() == Material.TOTEM_OF_UNDYING).findFirst().ifPresentOrElse(i -> {
            if (!totemShouldDrop) {
                event.getDrops().remove(i);
            }
        }, () -> {
            if (totemShouldDrop) {
                event.getDrops().add(this.totem);
            }
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onRaidEnd(RaidStopEvent event) {
        event.getRaid().getRaiders().stream().map(Entity::getUniqueId).forEach(this.raiders::remove);
    }

    @Override
    public void enable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PurpurExtras.getInstance());
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.raid-totem-drops.enabled", false);
    }
}

