/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class RespawnAnchorNeedsChargeModule
implements PurpurExtrasModule,
Listener {
    protected RespawnAnchorNeedsChargeModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return !PurpurExtras.getPurpurConfig().getBoolean("settings.gameplay-settings.respawn-anchor-needs-charges", true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!event.isAnchorSpawn()) {
            return;
        }
        Block block = event.getRespawnLocation().getBlock();
        BoundingBox box = BoundingBox.of((Location)block.getLocation(), (double)2.0, (double)2.0, (double)2.0);
        int y = (int)box.getMinY();
        while ((double)y < box.getMaxY()) {
            int x = (int)box.getMinX();
            while ((double)x < box.getMaxX()) {
                int z = (int)box.getMinZ();
                while ((double)z < box.getMaxZ()) {
                    Location location = new Location(event.getRespawnLocation().getWorld(), (double)x, (double)y, (double)z);
                    if (location.getBlock().getType().equals((Object)Material.RESPAWN_ANCHOR)) {
                        Block potentialAnchor = location.getBlock();
                        Bukkit.getScheduler().runTaskLater((Plugin)PurpurExtras.getInstance(), () -> {
                            if (!potentialAnchor.getType().equals((Object)Material.RESPAWN_ANCHOR)) {
                                return;
                            }
                            RespawnAnchor anchor = (RespawnAnchor)potentialAnchor.getBlockData();
                            anchor.setCharges(anchor.getMaximumCharges());
                            potentialAnchor.setBlockData((BlockData)anchor);
                        }, 2L);
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerPlaceAnchor(BlockPlaceEvent event) {
        if (!event.getBlockPlaced().getType().equals((Object)Material.RESPAWN_ANCHOR)) {
            return;
        }
        RespawnAnchor anchor = (RespawnAnchor)event.getBlockPlaced().getBlockData();
        anchor.setCharges(anchor.getMaximumCharges());
        event.getBlockPlaced().setBlockData((BlockData)anchor);
    }
}

