/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class SleepPercentageMessageModule
implements PurpurExtrasModule,
Listener {
    private final MiniMessage miniMsg;
    private final String playerSleepMessage;
    private final String nightSkipMessage;
    private final Permission sleepMessageBypass;

    protected SleepPercentageMessageModule() {
        this.miniMsg = PurpurExtras.getInstance().miniMessage;
        this.sleepMessageBypass = new Permission("purpurextras.sleepmessagebypass", "Allows player to not display a message in chat when they sleep", PermissionDefault.FALSE);
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        this.playerSleepMessage = config.getString("settings.chat.send-sleep-percentage-message.player-sleeping", "<grey><playername> has fallen asleep. <sleeping> out of <needed> required players in <worldname> are sleeping.");
        this.nightSkipMessage = config.getString("settings.chat.send-sleep-percentage-message.skipping-night", "<grey>Enough players have slept! Skipping through the night in <worldname>.");
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.sleepMessageBypass);
        if ((this.playerSleepMessage == null || this.playerSleepMessage.isBlank()) && (this.nightSkipMessage == null || this.nightSkipMessage.isBlank())) {
            return false;
        }
        return PurpurExtras.getPurpurConfig().getBoolean("settings.chat.send-sleep-percentage-message.enabled", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeepSleep(PlayerDeepSleepEvent event) {
        if (this.playerSleepMessage == null || this.playerSleepMessage.isBlank()) {
            return;
        }
        if (event.getPlayer().hasPermission(this.sleepMessageBypass)) {
            return;
        }
        World world = event.getPlayer().getWorld();
        List playerList = world.getPlayers();
        String playerName = event.getPlayer().getName();
        String worldName = world.getName();
        int currentSleepCount = 0;
        long worldOnlineTotal = playerList.stream().filter(player -> !player.isSleepingIgnored()).count();
        Integer worldSleepPercent = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        Integer neededSleepers = (int)Math.ceil((double)worldSleepPercent.intValue() / 100.0 * (double)worldOnlineTotal);
        for (Player player2 : playerList) {
            if (player2.isSleepingIgnored() || !player2.isDeeplySleeping()) continue;
            ++currentSleepCount;
        }
        world.sendMessage(this.miniMsg.deserialize(this.playerSleepMessage, new TagResolver[]{Placeholder.unparsed((String)"playername", (String)playerName), Placeholder.unparsed((String)"sleeping", (String)String.valueOf(currentSleepCount)), Placeholder.unparsed((String)"needed", (String)String.valueOf(neededSleepers)), Placeholder.unparsed((String)"worldname", (String)worldName)}));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void nightSkip(TimeSkipEvent event) {
        if (!event.getSkipReason().equals((Object)TimeSkipEvent.SkipReason.NIGHT_SKIP)) {
            return;
        }
        if (this.nightSkipMessage == null || this.nightSkipMessage.isBlank()) {
            return;
        }
        String worldName = event.getWorld().getName();
        event.getWorld().sendMessage(this.miniMsg.deserialize(this.nightSkipMessage, (TagResolver)Placeholder.unparsed((String)"worldname", (String)worldName)));
    }
}

