/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class SpawnerPlacementPermissionsModule
implements PurpurExtrasModule,
Listener {
    private final String basePermissionString = "purpurextras.spawnerplace.";

    protected SpawnerPlacementPermissionsModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerSpawnerPermissions(PurpurExtras.getInstance());
        return PurpurExtras.getPurpurConfig().getBoolean("settings.gameplay-settings.spawner-placement-requires-specific-permission", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSpawnerPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        BlockState blockState = event.getBlock().getState(false);
        if (!(blockState instanceof CreatureSpawner)) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        EntityType type = spawner.getSpawnedType();
        if (type == null) {
            return;
        }
        String entityName = type.getKey().getKey();
        if (player.hasPermission("purpurextras.spawnerplace." + entityName)) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(MiniMessage.miniMessage().deserialize("<red>You do not have permission to place a <spawner> spawner!", (TagResolver)Placeholder.unparsed((String)"spawner", (String)entityName)));
    }

    private void registerSpawnerPermissions(PurpurExtras plugin) {
        for (EntityType type : EntityType.values()) {
            if (!type.isAlive() || !type.isSpawnable()) continue;
            String entityName = type.getKey().getKey();
            Permission permission = new Permission("purpurextras.spawnerplace." + entityName, "Allows player to place a " + entityName + " spawner", PermissionDefault.OP);
            this.registerPermissions(permission);
        }
    }
}

