/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class StonecutterDamageModule
implements PurpurExtrasModule,
Listener {
    private final HashSet<EntityType> stonecutterDamageBlacklist = new HashSet();

    protected StonecutterDamageModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        List<String> entityBlacklist = config.getList("settings.stonecutter-damage-filter.blacklist", List.of("player"));
        if (config.getBoolean("settings.stonecutter-damage-filter.enabled", false)) {
            if (entityBlacklist.isEmpty()) {
                return;
            }
            for (EntityType entityType : EntityType.values()) {
                if (!entityType.isAlive()) continue;
                for (String str : entityBlacklist) {
                    if (!entityType.getKey().getKey().equals(str.toLowerCase(Locale.ENGLISH))) continue;
                    this.stonecutterDamageBlacklist.add(entityType);
                }
            }
        }
    }

    @Override
    public void enable() {
        try {
            Class.forName("org.purpurmc.purpur.PurpurConfig");
        }
        catch (ClassNotFoundException e) {
            PurpurExtras.getInstance().getLogger().warning(this.getClass().getSimpleName() + " module requires you to run Purpur as your server software.");
            return;
        }
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        if (this.stonecutterDamageBlacklist.isEmpty()) {
            return false;
        }
        return PurpurExtras.getPurpurConfig().getBoolean("settings.stonecutter-damage-filter.enabled", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onStonecutterDamage(EntityDamageEvent event) {
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.CONTACT)) {
            return;
        }
        if (!event.getEntity().isOnGround()) {
            return;
        }
        if (this.stonecutterDamageBlacklist.contains(event.getEntity().getType())) {
            event.setCancelled(true);
        }
    }
}

