/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class UnlockAllRecipesModule
implements PurpurExtrasModule,
Listener {
    private final Permission unlockRecipesPermission = new Permission("purpurextras.unlockallrecipesonjoin", "Players with this permission will have all recipes unlocked upon login if that feature is enabled in the config", PermissionDefault.TRUE);

    protected UnlockAllRecipesModule() {
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.unlockRecipesPermission);
        return PurpurExtras.getPurpurConfig().getBoolean("settings.unlock-all-recipes-on-join", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoinRecipeUnlock(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(this.unlockRecipesPermission)) {
            return;
        }
        Iterator recipes = Bukkit.recipeIterator();
        while (recipes.hasNext()) {
            Recipe recipe = (Recipe)recipes.next();
            if (!(recipe instanceof Keyed)) continue;
            Keyed keyedRecipe = (Keyed)recipe;
            player.discoverRecipe(keyedRecipe.getKey());
        }
    }
}

