/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;

public class VoidTotemModule
implements PurpurExtrasModule,
Listener {
    private final Collection<PotionEffect> totemEffects = new ArrayList<PotionEffect>();
    private final HashMap<UUID, Location> lastGroundedLocations = new HashMap();

    protected VoidTotemModule() {
        this.totemEffects.add(new PotionEffect(PotionEffectType.REGENERATION, 900, 1));
        this.totemEffects.add(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0));
        this.totemEffects.add(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1));
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        return PurpurExtras.getPurpurConfig().getBoolean("settings.totem.work-on-void-death", false);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        Location location = event.getTo().clone();
        if (location.subtract(0.0, 0.05, 0.0).getBlock().getType().isAir()) {
            return;
        }
        this.lastGroundedLocations.put(event.getPlayer().getUniqueId(), event.getTo().toCenterLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.lastGroundedLocations.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeathInVoid(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.VOID)) {
            return;
        }
        Location location = player.getLocation();
        if (location.getY() > (double)location.getWorld().getMinHeight()) {
            return;
        }
        if (player.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        if (!player.getInventory().getItemInMainHand().getType().equals((Object)Material.TOTEM_OF_UNDYING) && !player.getInventory().getItemInOffHand().getType().equals((Object)Material.TOTEM_OF_UNDYING)) {
            return;
        }
        event.setCancelled(true);
        Location safeLocation = this.lastGroundedLocations.getOrDefault(player.getUniqueId(), location.getWorld().getSpawnLocation());
        player.teleportAsync(safeLocation).thenRun(() -> this.useTotem(player));
    }

    private void useTotem(Player player) {
        ItemStack totem = null;
        if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.TOTEM_OF_UNDYING)) {
            totem = player.getInventory().getItemInMainHand();
        } else if (player.getInventory().getItemInOffHand().getType().equals((Object)Material.TOTEM_OF_UNDYING)) {
            totem = player.getInventory().getItemInOffHand();
        }
        if (totem == null) {
            return;
        }
        totem.subtract();
        player.setFallDistance(0.0f);
        player.setHealth(1.0);
        player.playEffect(EntityEffect.PROTECTED_FROM_DEATH);
        player.getActivePotionEffects().forEach(potionEffect -> player.removePotionEffect(potionEffect.getType()));
        player.addPotionEffects(this.totemEffects);
    }
}

